<?php
/**
 * Corpopress Pro: Color Patterns
 *
 * @package WordPress
 * @subpackage Corpopress Pro
 * @since 1.0
 */

/**
 * Generate the CSS for the current custom color scheme.
 */
function corpopress_pro_custom_colors_css() {
  	$options= corpopress_pro_get_theme_options();

	$color_value = $options['colorscheme_hue'];
	
	$css = '
	/*--------------------------------------------------------------
	## Background Color
	--------------------------------------------------------------*/
	.btn,
	#call-to-action .btn:hover,
	#call-to-action .btn:focus,
	#counter,
	#slider-section:before,
	#slider-section:after,
	#latest .btn-transparent:hover,
	#team,
	#respond input[type="submit"],
	.backtotop,
	.pagination .page-numbers,
	.pagination .page-numbers.dots:hover,
	.pagination .page-numbers.dots:focus,
	.pagination .page-numbers.prev,
	.pagination .page-numbers.next,
	.reply a:hover,
	.reply a:focus,
	.product-item-wrapper,
	.woocommerce .quantity .qty,
	.woocommerce div.product .woocommerce-tabs ul.tabs li.active,
	.woocommerce #review_form #respond textarea,
	.woocommerce-error,
	.woocommerce-info,
	.woocommerce-message,
	.menu-sticky #masthead.nav-shrink  {
	    background-color: '. esc_attr( $color_value ) .';
	}

	/*--------------------------------------------------------------
	## Text Color
	--------------------------------------------------------------*/

	.site-title a:hover,
	#featured-image .buttons .btn-default,
	.icon-container .fa:hover,
	#services .entry-title a:hover,
	#featured-slider article .entry-container .entry-title a:hover,
	#latest .btn-transparent,
	.testimonial-item-wrapper .entry-title a:hover,
	#team .btn-default,
	#team .hentry:hover .entry-title a,
	.blog-wrapper span.byline a:hover,
	.blog-wrapper .entry-container .entry-title a:hover,
	.blog-wrapper .entry-content p span a:hover,
	#colophon .site-info .site-wrapper.copyright a:hover,
	.reply a,
	input[type="submit"]:hover,
	input[type="submit"]:focus,
	#featured-image .btn-transparent:hover,
	#featured-image .btn-transparent:focus {
	    color: '. esc_attr( $color_value ) .';
	}

	.blog-wrapper .featured-image .entry-meta {
	    background-color: '. esc_attr( $color_value ) .';
	}

	#featured-image .buttons .btn-default:hover,
	.blog-wrapper .featured-image .entry-meta a:hover,
	.menu-sticky #masthead.nav-shrink .site-title a:hover {
	    color: #fff;
	}

	.btn-transparent {
	    color: #fff;
	    border: 1px solid #fff;
	    background-color: transparent;
	}

	#team .social-icons li a svg,
	.site-info .social-icons li a svg {
	    fill:'. esc_attr( $color_value ) .';
	}

	/*--------------------------------------------------------------
	## Border Color
	--------------------------------------------------------------*/
	#call-to-action .btn:hover:before  {
	    border-right-color: '. esc_attr( $color_value ) .';
	}

	#latest .btn-transparent,
	#latest .btn-transparent:hover,
	.reply a,
	.pagination .page-numbers,
	.pagination .page-numbers.dots:hover,
	.pagination .page-numbers.dots:focus,
	.pagination .page-numbers.prev,
	.pagination .page-numbers.next,
	.main-navigation form.search-form {
	    border-color: '. esc_attr( $color_value ) .';
	}

	.blog-wrapper .featured-image .entry-meta,
	.blog-wrapper .featured-image .entry-meta {
	    background-color: '. esc_attr( $color_value ) .';
	}

	#search:before,
	.woocommerce div.product .woocommerce-tabs ul.tabs li.active {
	    border-bottom: 9px solid '. esc_attr( $color_value ) .';
	}

	/*--------------------------------------------------------------
	## Preloader
	--------------------------------------------------------------*/
	@keyframes preloader {
	    0% {height:5px;transform:translateY(0px);background: '. esc_attr( $color_value ) .';}
	    25% {height:30px;transform:translateY(15px);background: '. esc_attr( $color_value ) .';}
	    50% {height:5px;transform:translateY(0px);background: '. esc_attr( $color_value ) .';}
	    100% {height:5px;transform:translateY(0px);background: '. esc_attr( $color_value ) .';}
	}


	@media screen and (min-width: 992px) {
	    .main-navigation ul ul {
	        background-color: '. esc_attr( $color_value ) .';
	    }
	}





	';

	/**
	 * Filters Corpopress Pro custom colors CSS.
	 *
	 * @since Corpopress Pro 1.0.0
	 *
	 * @param string $css        Base theme colors CSS.
	 */
	return apply_filters( 'corpopress_pro_custom_colors_css', $css );
}
