<?php
/**
 * Core file.
 *
 * This is the template that includes all the other files for core featured of Theme Palace
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */

/**
 * Load theme updater functions.
 * Action is used so that child themes can easily disable.
 */
function corpopress_pro_pro_theme_updater() {
    if( is_admin() ) {
        require get_template_directory() . '/inc/updater/theme-updater.php';
    }
}
add_action( 'after_setup_theme', 'corpopress_pro_pro_theme_updater' );

/**
 * Include options function.
 */
require get_template_directory() . '/inc/options.php';


// Load customizer defaults values
require get_template_directory() . '/inc/customizer/defaults.php';


/**
 * Merge values from default options array and values from customizer
 *
 * @return array Values returned from customizer
 * @since Corpopress Pro 1.0.0
 */
function corpopress_pro_get_theme_options() {
  $corpopress_pro_default_options = corpopress_pro_get_default_theme_options();

  return array_merge( $corpopress_pro_default_options , get_theme_mod( 'corpopress_pro_theme_options', $corpopress_pro_default_options ) ) ;
}

/**
 * Display custom color CSS.
 */
function corpopress_pro_colors_css_wrap() {
    $options= corpopress_pro_get_theme_options();
    if ( 'custom' !== $options['colorscheme'] ) {
        return;
    }

    require get_template_directory() . '/inc/color-pattern.php';
    $color = $options['colorscheme_hue'];
    ?>
    <style type="text/css" id="custom-theme-colors" <?php if ( is_customize_preview() ) { echo 'data-color="' . $color . '"'; } ?>>
        <?php echo corpopress_pro_custom_colors_css(); ?>
    </style>
<?php }
add_action( 'wp_head', 'corpopress_pro_colors_css_wrap' );

/**
 * Load admin custom styles
 * 
 */
function corpopress_pro_load_admin_style() {
    wp_register_style( 'corpopress_pro_admin_css', get_template_directory_uri() . '/assets/css/admin-style.css', false, '1.0.0' );
    wp_enqueue_style( 'corpopress_pro_admin_css' );
}
add_action( 'admin_enqueue_scripts', 'corpopress_pro_load_admin_style' );

/**
 * Add breadcrumb functions.
 */
require get_template_directory() . '/inc/breadcrumb-class.php';

/**
 * Add helper functions.
 */
require get_template_directory() . '/inc/helpers.php';

/**
 * Add structural hooks.
 */
require get_template_directory() . '/inc/structure.php';

/**
 * Add metabox
 */
require get_template_directory() . '/inc/metabox.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer/customizer.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/sections/sections.php';

if ( class_exists( 'WooCommerce' ) ) {
    /**
     * Woocommerce
     */
    require get_template_directory() . '/inc/woocommerce.php';
}

/**
* TGM plugin additions.
*/
require get_template_directory() . '/inc/tgm-plugin/tgm-hook.php';

if ( class_exists( 'CatchThemesDemoImportPlugin' ) ) {
    /**
    * OCDI plugin demo importer compatibility.
    */
    require get_template_directory() . '/inc/demo-import.php';
}

/**
* Download webfonts locally.
*/
require get_template_directory() . '/inc/wptt-webfont-loader.php';
