<?php
/**
 * Customizer active callbacks
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */

if ( ! function_exists( 'corpopress_pro_is_loader_enable' ) ) :
	/**
	 * Check if loader is enabled.
	 *
	 * @since Corpopress Pro 1.0.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function corpopress_pro_is_loader_enable( $control ) {
		return $control->manager->get_setting( 'corpopress_pro_theme_options[loader_enable]' )->value();
	}
endif;

if ( ! function_exists( 'corpopress_pro_is_breadcrumb_enable' ) ) :
	/**
	 * Check if breadcrumb is enabled.
	 *
	 * @since Corpopress Pro 1.0.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function corpopress_pro_is_breadcrumb_enable( $control ) {
		return $control->manager->get_setting( 'corpopress_pro_theme_options[breadcrumb_enable]' )->value();
	}
endif;

if ( ! function_exists( 'corpopress_pro_is_pagination_enable' ) ) :
	/**
	 * Check if pagination is enabled.
	 *
	 * @since Corpopress Pro 1.0.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function corpopress_pro_is_pagination_enable( $control ) {
		return $control->manager->get_setting( 'corpopress_pro_theme_options[pagination_enable]' )->value();
	}
endif;

/**
 * Front Page Active Callbacks
 */

/**
 * Check if slider section is enabled.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_slider_section_enable( $control ) {
	return ( $control->manager->get_setting( 'corpopress_pro_theme_options[slider_section_enable]' )->value() );
}

/**
 * Check if slider section content type is category.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_slider_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[slider_content_type]' )->value();
	return corpopress_pro_is_slider_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if slider section content type is page.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_slider_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[slider_content_type]' )->value();
	return corpopress_pro_is_slider_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if slider section content type is post.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_slider_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[slider_content_type]' )->value();
	return corpopress_pro_is_slider_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if about section is enabled.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_about_section_enable( $control ) {
	return ( $control->manager->get_setting( 'corpopress_pro_theme_options[about_section_enable]' )->value() );
}

/**
 * Check if about section content type is post.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_about_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[about_content_type]' )->value();
	return corpopress_pro_is_about_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if about section content type is page.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_about_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[about_content_type]' )->value();
	return corpopress_pro_is_about_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if about section content type is custom.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_about_section_content_custom_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[about_content_type]' )->value();
	return corpopress_pro_is_about_section_enable( $control ) && ( 'custom' == $content_type );
}

/**
 * Check if cta section is enabled.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_cta_section_enable( $control ) {
	return ( $control->manager->get_setting( 'corpopress_pro_theme_options[cta_section_enable]' )->value() );
}

/**
 * Check if cta section content type is post.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_cta_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[cta_content_type]' )->value();
	return corpopress_pro_is_cta_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if cta section content type is page.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_cta_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[cta_content_type]' )->value();
	return corpopress_pro_is_cta_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if cta section content type is custom.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_cta_section_content_custom_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[cta_content_type]' )->value();
	return corpopress_pro_is_cta_section_enable( $control ) && ( 'custom' == $content_type );
}

/**
 * Check if service section is enabled.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_service_section_enable( $control ) {
	return ( $control->manager->get_setting( 'corpopress_pro_theme_options[service_section_enable]' )->value() );
}

/**
 * Check if service section content type is post.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_service_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[service_content_type]' )->value();
	return corpopress_pro_is_service_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if service section seperator.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_service_section_content_seperator_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[service_content_type]' )->value();
	return corpopress_pro_is_service_section_enable( $control ) && ( in_array( $content_type, array( 'page', 'post' ) ) );
}

/**
 * Check if service section content type is page.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_service_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[service_content_type]' )->value();
	return corpopress_pro_is_service_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if service section content type is category.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_service_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[service_content_type]' )->value();
	return corpopress_pro_is_service_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if featured section is enabled.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_featured_section_enable( $control ) {
	return ( $control->manager->get_setting( 'corpopress_pro_theme_options[featured_section_enable]' )->value() );
}

/**
 * Check if featured section content type is category.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_featured_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[featured_content_type]' )->value();
	return corpopress_pro_is_featured_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if featured section content type is page.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_featured_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[featured_content_type]' )->value();
	return corpopress_pro_is_featured_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if featured section content type is post.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_featured_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[featured_content_type]' )->value();
	return corpopress_pro_is_featured_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if counter section is enabled.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_counter_section_enable( $control ) {
	return ( $control->manager->get_setting( 'corpopress_pro_theme_options[counter_section_enable]' )->value() );
}

/**
 * Check if promotion section is enabled.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_promotion_section_enable( $control ) {
	return ( $control->manager->get_setting( 'corpopress_pro_theme_options[promotion_section_enable]' )->value() );
}

/**
 * Check if promotion section content type is post.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_promotion_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[promotion_content_type]' )->value();
	return corpopress_pro_is_promotion_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if promotion section content type is page.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_promotion_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[promotion_content_type]' )->value();
	return corpopress_pro_is_promotion_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if promotion section content type is custom.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_promotion_section_content_custom_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[promotion_content_type]' )->value();
	return corpopress_pro_is_promotion_section_enable( $control ) && ( 'custom' == $content_type );
}

/**
 * Check if testimonial section is enabled.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_testimonial_section_enable( $control ) {
	return ( $control->manager->get_setting( 'corpopress_pro_theme_options[testimonial_section_enable]' )->value() );
}

/**
 * Check if testimonial section seperator.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_testimonial_section_content_seperator_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[testimonial_content_type]' )->value();
	return corpopress_pro_is_testimonial_section_enable( $control ) && ( 'category' !== $content_type );
}

/**
 * Check if testimonial section content type is post.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_testimonial_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[testimonial_content_type]' )->value();
	return corpopress_pro_is_testimonial_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if testimonial section content type is page.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_testimonial_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[testimonial_content_type]' )->value();
	return corpopress_pro_is_testimonial_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if testimonial section content type is category.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_testimonial_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[testimonial_content_type]' )->value();
	return corpopress_pro_is_testimonial_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if testimonial section content type is position.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_testimonial_section_content_position_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[testimonial_content_type]' )->value();
	return corpopress_pro_is_testimonial_section_enable( $control ) && ( 'category' !== $content_type );
}

/**
 * Check if testimonial section content type is custom.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_testimonial_section_content_custom_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[testimonial_content_type]' )->value();
	return corpopress_pro_is_testimonial_section_enable( $control ) && ( 'custom' == $content_type );
}

/**
 * Check if client section is enabled.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_client_section_enable( $control ) {
	return ( $control->manager->get_setting( 'corpopress_pro_theme_options[client_section_enable]' )->value() );
}

/**
 * Check if client section content type is post.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_client_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[client_content_type]' )->value();
	return corpopress_pro_is_client_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if client section content type is page.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_client_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[client_content_type]' )->value();
	return corpopress_pro_is_client_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if client section content type is category.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_client_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[client_content_type]' )->value();
	return corpopress_pro_is_client_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if client section content type is custom.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_client_section_content_custom_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[client_content_type]' )->value();
	return corpopress_pro_is_client_section_enable( $control ) && ( 'custom' == $content_type );
}

/**
 * Check if team section is enabled.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_team_section_enable( $control ) {
	return ( $control->manager->get_setting( 'corpopress_pro_theme_options[team_section_enable]' )->value() );
}

/**
 * Check if team section seperator.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_team_section_content_seperator_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[team_content_type]' )->value();
	return corpopress_pro_is_team_section_enable( $control ) && ( 'category' !== $content_type );
}

/**
 * Check if team section content type is post.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_team_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[team_content_type]' )->value();
	return corpopress_pro_is_team_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if team section content type is page.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_team_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[team_content_type]' )->value();
	return corpopress_pro_is_team_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if team section content type is category.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_team_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[team_content_type]' )->value();
	return corpopress_pro_is_team_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if team section content type is position.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_team_section_content_position_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[team_content_type]' )->value();
	return corpopress_pro_is_team_section_enable( $control ) && ( 'category' !== $content_type );
}

/**
 * Check if team section content type is custom.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_team_section_content_custom_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[team_content_type]' )->value();
	return corpopress_pro_is_team_section_enable( $control ) && ( 'custom' == $content_type );
}

/**
 * Check if blog section is enabled.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_blog_section_enable( $control ) {
	return ( $control->manager->get_setting( 'corpopress_pro_theme_options[blog_section_enable]' )->value() );
}

/**
 * Check if blog section content type is post.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_blog_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[blog_content_type]' )->value();
	return corpopress_pro_is_blog_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if blog section content type is page.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_blog_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[blog_content_type]' )->value();
	return corpopress_pro_is_blog_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if blog section content type is category.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_blog_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[blog_content_type]' )->value();
	return corpopress_pro_is_blog_section_enable( $control ) && ( 'category' == $content_type );
}

/**
 * Check if blog section content type is recent.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_blog_section_content_recent_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[blog_content_type]' )->value();
	return corpopress_pro_is_blog_section_enable( $control ) && ( 'recent' == $content_type );
}

/*===============Recent Posts=======================*/

/**
 * Check if recent section is enabled.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_recent_section_enable( $control ) {
	return ( $control->manager->get_setting( 'corpopress_pro_theme_options[recent_section_enable]' )->value() );
}

/**
 * Check if recent section content type is post.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_recent_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[recent_content_type]' )->value();
	return corpopress_pro_is_recent_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if recent section content type is page.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_recent_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[recent_content_type]' )->value();
	return corpopress_pro_is_recent_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if recent section content type is category.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_recent_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[recent_content_type]' )->value();
	return corpopress_pro_is_recent_section_enable( $control ) && ( 'category' == $content_type );
}

/*==================CTA=====================*/

/**
 * Check if sponsor section is enabled.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_sponsor_section_enable( $control ) {
	return ( $control->manager->get_setting( 'corpopress_pro_theme_options[sponsor_section_enable]' )->value() );
}

/**
 * Check if sponsor section content type is post.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_sponsor_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[sponsor_content_type]' )->value();
	return corpopress_pro_is_sponsor_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if sponsor section content type is page.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_sponsor_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[sponsor_content_type]' )->value();
	return corpopress_pro_is_sponsor_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if sponsor section content type is custom.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_sponsor_section_content_custom_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[sponsor_content_type]' )->value();
	return corpopress_pro_is_sponsor_section_enable( $control ) && ( 'custom' == $content_type );
}

/*===============Popular Posts=======================*/

/**
 * Check if popular section is enabled.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_popular_section_enable( $control ) {
	return ( $control->manager->get_setting( 'corpopress_pro_theme_options[popular_section_enable]' )->value() );
}

/**
 * Check if popular section content type is post.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_popular_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[popular_content_type]' )->value();
	return corpopress_pro_is_popular_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if popular section content type is page.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_popular_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[popular_content_type]' )->value();
	return corpopress_pro_is_popular_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if popular section content type is category.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_popular_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[popular_content_type]' )->value();
	return corpopress_pro_is_popular_section_enable( $control ) && ( 'category' == $content_type );
}

/*===============Most Viewed Posts=======================*/

/**
 * Check if most_viewed section is enabled.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_most_viewed_section_enable( $control ) {
	return ( $control->manager->get_setting( 'corpopress_pro_theme_options[most_viewed_section_enable]' )->value() );
}

/**
 * Check if most_viewed section content type is post.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_most_viewed_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[most_viewed_content_type]' )->value();
	return corpopress_pro_is_most_viewed_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if most_viewed section content type is page.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_most_viewed_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[most_viewed_content_type]' )->value();
	return corpopress_pro_is_most_viewed_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if most_viewed section content type is category.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_most_viewed_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[most_viewed_content_type]' )->value();
	return corpopress_pro_is_most_viewed_section_enable( $control ) && ( 'category' == $content_type );
}

/*===============Topbar=======================*/

/**
 * Check if topbar section is enabled.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_topbar_section_enable( $control ) {
	return ( $control->manager->get_setting( 'corpopress_pro_theme_options[topbar_enable]' )->value() );
}

/*===============Breaking News=======================*/

/**
 * Check if breaking_news section is enabled.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_breaking_news_section_enable( $control ) {
	return ( $control->manager->get_setting( 'corpopress_pro_theme_options[breaking_news_section_enable]' )->value() );
}

/**
 * Check if breaking_news section content type is post.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_breaking_news_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[breaking_news_content_type]' )->value();
	return corpopress_pro_is_breaking_news_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if breaking_news section content type is page.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_breaking_news_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[breaking_news_content_type]' )->value();
	return corpopress_pro_is_breaking_news_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if breaking_news section content type is category.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_breaking_news_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[breaking_news_content_type]' )->value();
	return corpopress_pro_is_breaking_news_section_enable( $control ) && ( 'category' == $content_type );
}

/*===============Highlighted Posts=======================*/

/**
 * Check if highlighted_posts section is enabled.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_highlighted_posts_section_enable( $control ) {
	return ( $control->manager->get_setting( 'corpopress_pro_theme_options[highlighted_posts_section_enable]' )->value() );
}

/**
 * Check if highlighted_posts section content type is post.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_highlighted_posts_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[highlighted_posts_content_type]' )->value();
	return corpopress_pro_is_highlighted_posts_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if highlighted_posts section content type is page.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_highlighted_posts_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[highlighted_posts_content_type]' )->value();
	return corpopress_pro_is_highlighted_posts_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if highlighted_posts section content type is category.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_highlighted_posts_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[highlighted_posts_content_type]' )->value();
	return corpopress_pro_is_highlighted_posts_section_enable( $control ) && ( 'category' == $content_type );
}

/*===============Most Popular=======================*/

/**
 * Check if most_popular section is enabled.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_most_popular_section_enable( $control ) {
	return ( $control->manager->get_setting( 'corpopress_pro_theme_options[most_popular_section_enable]' )->value() );
}

/**
 * Check if most_popular section content type is post.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_most_popular_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[most_popular_content_type]' )->value();
	return corpopress_pro_is_most_popular_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if most_popular section content type is page.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_most_popular_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[most_popular_content_type]' )->value();
	return corpopress_pro_is_most_popular_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if most_popular section content type is category.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_most_popular_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[most_popular_content_type]' )->value();
	return corpopress_pro_is_most_popular_section_enable( $control ) && ( 'category' == $content_type );
}

/*===============Politics=======================*/

/**
 * Check if politics section is enabled.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_politics_section_enable( $control ) {
	return ( $control->manager->get_setting( 'corpopress_pro_theme_options[politics_section_enable]' )->value() );
}

/**
 * Check if politics section content type is post.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_politics_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[politics_content_type]' )->value();
	return corpopress_pro_is_politics_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if politics section content type is page.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_politics_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[politics_content_type]' )->value();
	return corpopress_pro_is_politics_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if politics section content type is category.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_politics_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[politics_content_type]' )->value();
	return corpopress_pro_is_politics_section_enable( $control ) && ( 'category' == $content_type );
}

/*===============Sports=======================*/

/**
 * Check if sports section is enabled.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_sports_section_enable( $control ) {
	return ( $control->manager->get_setting( 'corpopress_pro_theme_options[sports_section_enable]' )->value() );
}

/**
 * Check if sports section content type is post.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_sports_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[sports_content_type]' )->value();
	return corpopress_pro_is_sports_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if sports section content type is page.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_sports_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[sports_content_type]' )->value();
	return corpopress_pro_is_sports_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if sports section content type is category.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_sports_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[sports_content_type]' )->value();
	return corpopress_pro_is_sports_section_enable( $control ) && ( 'category' == $content_type );
}

/*===============Two Column=======================*/

/**
 * Check if two_column section is enabled.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_two_column_section_enable( $control ) {
	return ( $control->manager->get_setting( 'corpopress_pro_theme_options[two_column_section_enable]' )->value() );
}

/**
 * Check if two_column section content type is post.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_two_column_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[two_column_content_type]' )->value();
	return corpopress_pro_is_two_column_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if two_column section content type is page.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_two_column_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[two_column_content_type]' )->value();
	return corpopress_pro_is_two_column_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if two_column section content type is category.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_two_column_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[two_column_content_type]' )->value();
	return corpopress_pro_is_two_column_section_enable( $control ) && ( 'category' == $content_type );
}

/*=================Latest Products================*/

function corpopress_pro_is_latest_products_section_enable( $control ) {
	return ( $control->manager->get_setting( 'corpopress_pro_theme_options[latest_products_section_enable]' )->value() );
}

function corpopress_pro_is_latest_products_section_content_product_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[latest_products_content_type]' )->value();
	return corpopress_pro_is_latest_products_section_enable( $control ) && ( 'product' == $content_type );
}

function corpopress_pro_is_latest_products_section_content_product_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[latest_products_content_type]' )->value();
	return corpopress_pro_is_latest_products_section_enable( $control ) && ( 'product-category' == $content_type );
}

/*=================Popular Products================*/

function corpopress_pro_is_popular_products_section_enable( $control ) {
	return ( $control->manager->get_setting( 'corpopress_pro_theme_options[popular_products_section_enable]' )->value() );
}

function corpopress_pro_is_popular_products_section_content_product_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[popular_products_content_type]' )->value();
	return corpopress_pro_is_popular_products_section_enable( $control ) && ( 'product' == $content_type );
}

function corpopress_pro_is_popular_products_section_content_product_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[popular_products_content_type]' )->value();
	return corpopress_pro_is_popular_products_section_enable( $control ) && ( 'product-category' == $content_type );
}

/*=================Products Collection================*/

function corpopress_pro_is_collection_section_enable( $control ) {
	return ( $control->manager->get_setting( 'corpopress_pro_theme_options[collection_section_enable]' )->value() ) && class_exists( 'WooCommerce' );
}

/*=================Featured Products================*/

function corpopress_pro_is_featured_products_section_enable( $control ) {
	return ( $control->manager->get_setting( 'corpopress_pro_theme_options[featured_products_section_enable]' )->value() ) && class_exists( 'WooCommerce' );
}

/*=================Recent Products================*/

function corpopress_pro_is_recent_products_section_enable( $control ) {
	return ( $control->manager->get_setting( 'corpopress_pro_theme_options[recent_products_section_enable]' )->value() );
}

function corpopress_pro_is_recent_products_section_content_product_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[recent_products_content_type]' )->value();
	return corpopress_pro_is_recent_products_section_enable( $control ) && ( 'product' == $content_type );
}

function corpopress_pro_is_recent_products_section_content_product_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'corpopress_pro_theme_options[recent_products_content_type]' )->value();
	return corpopress_pro_is_recent_products_section_enable( $control ) && ( 'product-category' == $content_type );
}

/**
 * Check if subscription section is enabled.
 *
 * @since Corpopress Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function corpopress_pro_is_subscription_section_enable( $control ) {
	return ( $control->manager->get_setting( 'corpopress_pro_theme_options[subscription_section_enable]' )->value() );
}

//pro layout 
function corpopress_pro_is_default_layout( $control ) {
	$design = $control->manager->get_setting( 'corpopress_pro_theme_options[home_layout]' )->value();
	return ( 'default-design' == $design );
}

//second layout 
function corpopress_pro_is_second_layout( $control ) {
	$design = $control->manager->get_setting( 'corpopress_pro_theme_options[home_layout]' )->value();
	return ( 'second-design' == $design );
}

//third layout 
function corpopress_pro_is_third_layout( $control ) {
	$design = $control->manager->get_setting( 'corpopress_pro_theme_options[home_layout]' )->value();
	return ( 'third-design' == $design );
}

//third layout 
function corpopress_pro_is_fourth_layout( $control ) {
	$design = $control->manager->get_setting( 'corpopress_pro_theme_options[home_layout]' )->value();
	return ( 'fourth-design' == $design );
}