<?php
/**
 * Customizer default options
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 * @return array An array of default values
 */

function corpopress_pro_get_default_theme_options() {
	$theme_data = wp_get_theme();
	$corpopress_pro_default_options = array(
		// Color Options
		'header_title_color'			=> '#fff',
		'header_tagline_color'			=> '#fff',
		'header_txt_logo_extra'			=> 'show-all',
		'colorscheme_hue'				=> '#000',
		'colorscheme'					=> 'default',
		'home_layout'					=> 'default-design',
		
		// typography Options
		'theme_typography' 				=> 'default',
		'body_theme_typography' 		=> 'default',
		
		// loader
		'loader_enable'         		=> false,
		'loader_icon'         			=> 'default',

		// breadcrumb
		'breadcrumb_enable'				=> true,
		'breadcrumb_separator'			=> '/',
		
		// layout 
		'site_layout'         			=> 'wide',
		'sidebar_position'         		=> 'right-sidebar',
		'post_sidebar_position' 		=> 'right-sidebar',
		'page_sidebar_position' 		=> 'right-sidebar',
		'menu_sticky'					=> true,
		'nav_search_enable'				=> true,

		// excerpt options
		'long_excerpt_length'           => 25,
		'read_more_text'           		=> esc_html__( '( Read More )', 'corpopress-pro' ),
		
		// pagination options
		'pagination_enable'         	=> true,
		'pagination_type'         		=> 'default',

		// footer options
		'copyright_text'           		=> sprintf( esc_html_x( 'Copyright &copy; %1$s %2$s. ', '1: Year, 2: Site Title with home URL', 'corpopress-pro' ), '[the-year]', '[site-link]' ) . esc_html__( 'All Rights Reserved | ', 'corpopress-pro' ) . esc_html( $theme_data->get( 'Name') ) . '&nbsp;' . esc_html__( 'by', 'corpopress-pro' ). '&nbsp;<a target="_blank" href="'. esc_url( $theme_data->get( 'AuthorURI' ) ) .'">'. esc_html( ucwords( $theme_data->get( 'Author' ) ) ) .'</a>',
		'scroll_top_visible'        	=> true,

		// reset options
		'reset_options'      			=> false,
		
		// homepage options
		'enable_frontpage_content' 		=> false,

		// homepage sections sortable
		
		'all_sortable'				=> 'breaking_news,highlighted_posts,most_popular,politics,sports,two_column,slider,latest_products,popular_products,collection,featured_products,recent_products,about,recent,cta,service,featured,sponsor,popular,most_viewed,counter,promotion,testimonial,client,team,blog,subscription',

		// homepage sections sortable
		'default_sortable' 						=> 'slider,about,cta,service,featured,counter,promotion,testimonial,client,team,blog,subscription',

		'second_sortable' 						=> 'slider,recent,featured,sponsor,popular,most_viewed,blog,subscription',
		
		'third_sortable' 						=> 'breaking_news,highlighted_posts,most_popular,politics,sports,two_column,blog,subscription',
		
		'fourth_sortable' 						=> 'slider,latest_products,popular_products,collection,featured_products,recent_products,blog,subscription',
		

		// blog/archive options
		'your_latest_posts_title' 		=> esc_html__( 'Blogs', 'corpopress-pro' ),
		'hide_date' 					=> false,
		'hide_author'					=> false,
		'archive_column'				=> 'col-2',

		// single post theme options
		'single_post_hide_date' 		=> false,
		'single_post_hide_author'		=> false,
		'single_post_hide_category'		=> false,
		'single_post_hide_tags'			=> false,

		/* Front Page */

		// topbar
		'topbar_enable'					=> false,
		'topbar_social_enable'			=> false,
		'topbar_phone'					=> esc_html__( '+0 00 000000000', 'corpopress-pro' ),
		'topbar_email'					=> esc_html__( 'support@gmail.com', 'corpopress-pro' ),
		'topbar_location'				=> esc_html__( '35 West Dental Street, California 1004', 'corpopress-pro' ),

		// Slider
		'slider_section_enable'			=> true,
		'slider_opacity_enable'			=> false,
		'slider_content_type'			=> 'category',
		'slider_count'					=> 3,
		'slider_excerpt'				=> 10,
		'slider_btn_label'				=> esc_html__( 'Learn More', 'corpopress-pro' ),
		'slider_alt_btn_label'			=> esc_html__( 'Contact Us', 'corpopress-pro' ),

		// About
		'about_section_enable'			=> true,
		'about_content_type'			=> 'page',
		'about_title'					=> esc_html__( 'Perfect Business Solutions', 'corpopress-pro' ),
		'about_description'				=> esc_html__( 'After you have your new site, the work begins. The Marketplace offers a vetted collection of free and paid add-ons, resources, products and services. Stop spending time looking for the best solution and just run your business.', 'corpopress-pro' ),
		'about_btn_title'				=> esc_html__( 'Learn More', 'corpopress-pro' ),

		// recent
		'recent_section_enable'			=> true,
		'recent_author_enable'			=> true,
		'recent_content_type'			=> 'category',
		'recent_count'					=> 3,
		'recent_excerpt'				=> 10,
		'recent_column'					=> 'col-3',
		'recent_title'					=> esc_html__( 'Lifestyle & Fashion', 'corpopress-pro' ),

		// call to action
		'cta_section_enable'			=> true,
		'cta_content_type'				=> 'page',
		'cta_title'						=> esc_html__( 'We Help You To Grow Your Business', 'corpopress-pro' ),
		'cta_btn_title'					=> esc_html__( 'Need Our Help? Contact Us', 'corpopress-pro' ),
		'cta_description'				=> esc_html__( 'All of our Client Care team works in our offices and is an experiemnced Web Meeting user ready to help you. Never outsourced.', 'corpopress-pro' ),

		// service
		'service_section_enable'		=> true,
		'service_content_type'			=> 'category',
		'service_count'					=> 4,
		'service_column'				=> 'col-4',
		'service_title'					=> esc_html__( 'We Offer Our Best For Your Success', 'corpopress-pro' ),

		// Featured
		'featured_section_enable'		=> true,
		'featured_content_type'			=> 'category',
		'featured_count'				=> 4,

		// Counter
		'counter_section_enable'		=> true,

		// Promotion
		'promotion_section_enable'		=> true,
		'promotion_content_type'		=> 'page',
		'promotion_title'				=> esc_html__( 'Perfect Responsive Design For All Theme', 'corpopress-pro' ),
		'promotion_description'			=> esc_html__( 'After you have your new site, the work begins. The Marketplace offers a vetted collection of free and paid add-ons, resources, products and services. Stop spending time looking for the best solution and just run your business.', 'corpopress-pro' ),
		'promotion_btn_title'			=> esc_html__( 'Try it Free', 'corpopress-pro' ),
		'promotion_alt_btn_title'		=> esc_html__( 'Upgrade to Pro', 'corpopress-pro' ),

		// testimonial
		'testimonial_section_enable'	=> true,
		'testimonial_content_type'		=> 'category',
		'testimonial_column'			=> 'col-4',
		'testimonial_count'				=> 4,
		'testimonial_title'				=> esc_html__( 'Loved by business, and individuals across the globe', 'corpopress-pro' ),

		// clients
		'client_section_enable'			=> true,
		'client_column'					=> 5,
		'client_content_type'			=> 'category',
		'client_count'					=> 5,

		// team
		'team_section_enable'			=> true,
		'team_content_type'				=> 'category',
		'team_count'					=> 4,
		'team_title'					=> esc_html__( 'Loved by business, and individuals across the globe', 'corpopress-pro' ),
		'team_btn_title'				=> esc_html__( 'Contact Us', 'corpopress-pro' ),

		// blog
		'blog_section_enable'			=> true,
		'blog_author_enable'			=> true,
		'blog_content_type'				=> 'recent',
		'blog_count'					=> 3,
		'blog_column'					=> 'col-3',
		'blog_title'					=> esc_html__( 'Here&#39;s a good news, check our blog and more', 'corpopress-pro' ),

		// Subscription
		'subscription_section_enable'	=> false,
		'subscription_title'			=> esc_html__( 'Don&#39;t miss any updates', 'corpopress-pro' ),
		'subscription_subtitle'			=> esc_html__( 'Subscribe in seconds. No requirements. Cancel anytime.', 'corpopress-pro' ),
		'subscription_btn_title'		=> esc_html__( 'Subscribe Now', 'corpopress-pro' ),
		'subscription_image'			=> get_template_directory_uri() . '/assets/uploads/subscribe.jpg',

		// blog
		'sponsor_section_enable'			=> true,
		'sponsor_excerpt_length'			=> 25,
		'sponsor_content_type'				=> 'page',
		'sponsor_title'						=> esc_html__( 'California Road Trip', 'corpopress-pro' ),
		'sponsor_description'				=> esc_html__( 'Accumsan iaculis, ducimus rutrum donec eiusmod, habitant quaerat, accusantium aperiam blandit, volutpat pede aliquet, litora per? Odio natus eu commodo. Adipiscing justo, laboris', 'corpopress-pro' ),
		'sponsor_btn_title'					=> esc_html__( 'Explore More', 'corpopress-pro' ),

		// popular
		'popular_section_enable'			=> true,
		'popular_content_type'				=> 'category',
		'popular_count'						=> 4,
		'popular_excerpt'					=> 20,
		'popular_title'						=> esc_html__( 'Adventure', 'corpopress-pro' ),

		// most_viewed
		'most_viewed_section_enable'		=> true,
		'most_viewed_content_type'			=> 'category',
		'most_viewed_count'					=> 4,
		'most_viewed_title'					=> esc_html__( 'Lifestyle', 'corpopress-pro' ),

		// breaking_news
		'breaking_news_section_enable'			=> true,
		'breaking_news_content_type'			=> 'category',
		'breaking_news_count'					=> 3,
		'breaking_news_title'					=> esc_html__( 'BREAKING NEWS', 'corpopress-pro' ),

		// highlighted_posts
		'highlighted_posts_section_enable'			=> true,
		'highlighted_posts_content_type'			=> 'post',
		'highlighted_posts_count'					=> 5,

		// most_popular
		'most_popular_section_enable'			=> true,
		'most_popular_content_type'				=> 'post',
		'most_popular_count'					=> 4,
		'most_popular_title'					=> esc_html__( 'Most popular', 'corpopress-pro' ),

		// politics
		'politics_section_enable'			=> true,
		'politics_content_type'				=> 'post',
		'politics_count'					=> 5,
		'politics_title'					=> esc_html__( 'Politics Posts', 'corpopress-pro' ),

		// sports
		'sports_section_enable'			=> true,
		'sports_content_type'			=> 'post',
		'sports_count'					=> 4,
		'sports_excerpt'				=> 15,
		'sports_title'					=> esc_html__( 'Sports Posts', 'corpopress-pro' ),

		// two_column
		'two_column_section_enable'			=> true,
		'two_column_content_type'			=> 'post',
		'two_column_count'					=> 4,
		'two_column_excerpt'				=> 15,
		'two_column_title'					=> esc_html__( 'Two Column Posts', 'corpopress-pro' ),

		//latest products
		'latest_products_section_enable'	=> true,
		'latest_products_content_type'		=> 'product-category',
		'latest_products_count'				=> 3,
		'latest_products_col_layout'		=> 'col-3',
		'latest_products_button'			=> esc_html__( 'Explore Items', 'corpopress-pro' ),

		//popular products
		'popular_products_section_enable'	=> true,
		'popular_products_content_type'		=> 'product-category',
		'popular_products_count'			=> 4,
		'popular_products_title'			=> esc_html__( 'Bestsellers Products', 'corpopress-pro' ),
		'popular_products_sub_title'		=> esc_html__( 'Autem neglegentur in duo, ex aperiam fabulas mei, exerci menandri explicari ut mei. Eam cibo et.', 'corpopress-pro' ),

		//collection products
		'collection_section_enable'	=> true,
		'collection_count'			=> 5,

		//featured_products
		'featured_products_section_enable'		=> true,
		'featured_products_count'				=> 2,

		//recent products
		'recent_products_section_enable'	=> true,
		'recent_products_content_type'		=> 'product-category',
		'recent_products_count'			=> 4,
		'recent_products_title'			=> esc_html__( 'Recent Products', 'corpopress-pro' ),
		'recent_products_sub_title'		=> esc_html__( 'Autem neglegentur in duo, ex aperiam fabulas mei, exerci menandri explicari ut mei. Eam cibo et.', 'corpopress-pro' ),

	);

	$output = apply_filters( 'corpopress_pro_default_theme_options', $corpopress_pro_default_options );

	// Sort array in ascending order, according to the key:
	if ( ! empty( $output ) ) {
		ksort( $output );
	}

	return $output;
}