<?php
/**
 * Blog Section options
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */

// Add Blog section
$wp_customize->add_section( 'corpopress_pro_blog_section', array(
	'title'             => esc_html__( 'Blog','corpopress-pro' ),
	'description'       => esc_html__( 'Blog Section options.', 'corpopress-pro' ),
	'panel'             => 'corpopress_pro_front_page_panel',
	'active_callback'   => function( $control ) {
        return ( 
            corpopress_pro_is_default_layout( $control )
            ||
            corpopress_pro_is_second_layout( $control )
            ||
            corpopress_pro_is_third_layout( $control )
            ||
            corpopress_pro_is_fourth_layout( $control )
        );
    },
) );

// Blog content enable control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[blog_section_enable]', array(
	'default'			=> 	$options['blog_section_enable'],
	'sanitize_callback' => 'corpopress_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Corpopress_Pro_Switch_Control( $wp_customize, 'corpopress_pro_theme_options[blog_section_enable]', array(
	'label'             => esc_html__( 'Blog Section Enable', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_blog_section',
	'on_off_label' 		=> corpopress_pro_switch_options(),
) ) );

// blog title setting and control
$wp_customize->add_setting( 'corpopress_pro_theme_options[blog_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['blog_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[blog_title]', array(
	'label'           	=> esc_html__( 'Title', 'corpopress-pro' ),
	'section'        	=> 'corpopress_pro_blog_section',
	'active_callback' 	=> 'corpopress_pro_is_blog_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'corpopress_pro_theme_options[blog_title]', array(
		'selector'            => '#blog h2.section-title',
		'settings'            => 'corpopress_pro_theme_options[blog_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'corpopress_pro_blog_title_partial',
    ) );
}

// Blog content type control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[blog_column]', array(
	'default'          	=> $options['blog_column'],
	'sanitize_callback' => 'corpopress_pro_sanitize_select',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[blog_column]', array(
	'label'             => esc_html__( 'Column Layout', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_blog_section',
	'type'				=> 'select',
	'active_callback' 	=> 'corpopress_pro_is_blog_section_enable',
	'choices'			=> array( 
		'col-2' 	=> esc_html__( 'Two Column', 'corpopress-pro' ),
		'col-3' 	=> esc_html__( 'Three Column', 'corpopress-pro' ),
		'col-4' 	=> esc_html__( 'Four Column', 'corpopress-pro' ),
	),
) );

// Blog content enable control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[blog_author_enable]', array(
	'default'			=> 	$options['blog_author_enable'],
	'sanitize_callback' => 'corpopress_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Corpopress_Pro_Switch_Control( $wp_customize, 'corpopress_pro_theme_options[blog_author_enable]', array(
	'label'             => esc_html__( 'Enable Author', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_blog_section',
	'on_off_label' 		=> corpopress_pro_switch_options(),
	'active_callback' 	=> 'corpopress_pro_is_blog_section_enable',
) ) );

// Blog content type control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[blog_content_type]', array(
	'default'          	=> $options['blog_content_type'],
	'sanitize_callback' => 'corpopress_pro_sanitize_select',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[blog_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_blog_section',
	'type'				=> 'select',
	'active_callback' 	=> 'corpopress_pro_is_blog_section_enable',
	'choices'			=> array( 
		'page' 		=> esc_html__( 'Page', 'corpopress-pro' ),
		'post' 		=> esc_html__( 'Post', 'corpopress-pro' ),
		'category' 	=> esc_html__( 'Category', 'corpopress-pro' ),
		'recent' 	=> esc_html__( 'Recent', 'corpopress-pro' ),
	),
) );

// Event social icons number control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[blog_count]', array(
	'default'          	=> $options['blog_count'],
	'sanitize_callback' => 'corpopress_pro_sanitize_number_range',
	'validate_callback' => 'corpopress_pro_validate_blog_count',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[blog_count]', array(
	'label'             => esc_html__( 'Number of Posts', 'corpopress-pro' ),
	'description'       => esc_html__( 'Note: Min 2 & Max 50. Please input the valid number and save. Then refresh the page to see the change.', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_blog_section',
	'active_callback'   => 'corpopress_pro_is_blog_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 2,
		'max'	=> 50,
		'style' => 'width: 100px;'
		),
) );

for ( $i = 1; $i <= $options['blog_count']; $i++ ) :
	// blog pages drop down chooser control and setting
	$wp_customize->add_setting( 'corpopress_pro_theme_options[blog_content_page_' . $i . ']', array(
		'sanitize_callback' => 'corpopress_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Corpopress_Pro_Dropdown_Chooser( $wp_customize, 'corpopress_pro_theme_options[blog_content_page_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Page %d', 'corpopress-pro' ), $i ),
		'section'           => 'corpopress_pro_blog_section',
		'choices'			=> corpopress_pro_page_choices(),
		'active_callback'	=> 'corpopress_pro_is_blog_section_content_page_enable',
	) ) );

	// blog posts drop down chooser control and setting
	$wp_customize->add_setting( 'corpopress_pro_theme_options[blog_content_post_' . $i . ']', array(
		'sanitize_callback' => 'corpopress_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Corpopress_Pro_Dropdown_Chooser( $wp_customize, 'corpopress_pro_theme_options[blog_content_post_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Post %d', 'corpopress-pro' ), $i ),
		'section'           => 'corpopress_pro_blog_section',
		'choices'			=> corpopress_pro_post_choices(),
		'active_callback'	=> 'corpopress_pro_is_blog_section_content_post_enable',
	) ) );
endfor;

// Add dropdown category setting and control.
$wp_customize->add_setting(  'corpopress_pro_theme_options[blog_content_category]', array(
	'sanitize_callback' => 'corpopress_pro_sanitize_single_category',
) ) ;

$wp_customize->add_control( new Corpopress_Pro_Dropdown_Taxonomies_Control( $wp_customize,'corpopress_pro_theme_options[blog_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'corpopress-pro' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_blog_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'corpopress_pro_is_blog_section_content_category_enable'
) ) );

// Add dropdown categories setting and control.
$wp_customize->add_setting( 'corpopress_pro_theme_options[blog_category_exclude]', array(
	'sanitize_callback' => 'corpopress_pro_sanitize_category_list',
) ) ;

$wp_customize->add_control( new Corpopress_Pro_Dropdown_Category_Control( $wp_customize,'corpopress_pro_theme_options[blog_category_exclude]', array(
	'label'             => esc_html__( 'Select Excluding Categories', 'corpopress-pro' ),
	'description'      	=> esc_html__( 'Note: Select categories to exclude. Press Shift key select multilple categories.', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_blog_section',
	'type'              => 'dropdown-categories',
	'active_callback'	=> 'corpopress_pro_is_blog_section_content_recent_enable'
) ) );
