<?php
/**
 * Client Section options
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */

// Add Client section
$wp_customize->add_section( 'corpopress_pro_client_section', array(
	'title'             => esc_html__( 'Client','corpopress-pro' ),
	'description'       => esc_html__( 'Client Section options.', 'corpopress-pro' ),
	'panel'             => 'corpopress_pro_front_page_panel',
	'active_callback'   => function( $control ) {
        return ( 
            corpopress_pro_is_default_layout( $control )
        );
    },
) );

// Client content enable control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[client_section_enable]', array(
	'default'			=> 	$options['client_section_enable'],
	'sanitize_callback' => 'corpopress_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Corpopress_Pro_Switch_Control( $wp_customize, 'corpopress_pro_theme_options[client_section_enable]', array(
	'label'             => esc_html__( 'Client Section Enable', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_client_section',
	'on_off_label' 		=> corpopress_pro_switch_options(),
) ) );

// Client content type control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[client_column]', array(
	'default'          	=> $options['client_column'],
	'sanitize_callback' => 'corpopress_pro_sanitize_select',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[client_column]', array(
	'label'             => esc_html__( 'Column Layout', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_client_section',
	'type'				=> 'select',
	'active_callback' 	=> 'corpopress_pro_is_client_section_enable',
	'choices'			=> array( 
		4 		=> esc_html__( 'Four Column', 'corpopress-pro' ),
		5 		=> esc_html__( 'Five Column', 'corpopress-pro' ),
	),
) );

// Client content type control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[client_content_type]', array(
	'default'          	=> $options['client_content_type'],
	'sanitize_callback' => 'corpopress_pro_sanitize_select',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[client_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_client_section',
	'type'				=> 'select',
	'active_callback' 	=> 'corpopress_pro_is_client_section_enable',
	'choices'			=> array( 
		'page' 		=> esc_html__( 'Page', 'corpopress-pro' ),
		'post' 		=> esc_html__( 'Post', 'corpopress-pro' ),
		'category' 	=> esc_html__( 'Category', 'corpopress-pro' ),
		'custom' 	=> esc_html__( 'Custom', 'corpopress-pro' ),
	),
) );

// Event social icons number control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[client_count]', array(
	'default'          	=> $options['client_count'],
	'sanitize_callback' => 'corpopress_pro_sanitize_number_range',
	'validate_callback' => 'corpopress_pro_validate_client_count',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[client_count]', array(
	'label'             => esc_html__( 'Number of Clients', 'corpopress-pro' ),
	'description'       => esc_html__( 'Note: Min 1 & Max 12. Please input the valid number and save. Then refresh the page to see the change.', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_client_section',
	'active_callback'   => 'corpopress_pro_is_client_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'max'	=> 12,
		'style' => 'width: 100px;'
		),
) );

// Add dropdown category setting and control.
$wp_customize->add_setting(  'corpopress_pro_theme_options[client_content_category]', array(
	'sanitize_callback' => 'corpopress_pro_sanitize_single_category',
) ) ;

$wp_customize->add_control( new Corpopress_Pro_Dropdown_Taxonomies_Control( $wp_customize,'corpopress_pro_theme_options[client_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'corpopress-pro' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_client_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'corpopress_pro_is_client_section_content_category_enable'
) ) );

for ( $i = 1; $i <= $options['client_count']; $i++ ) :
	// client pages drop down chooser control and setting
	$wp_customize->add_setting( 'corpopress_pro_theme_options[client_content_page_' . $i . ']', array(
		'sanitize_callback' => 'corpopress_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Corpopress_Pro_Dropdown_Chooser( $wp_customize, 'corpopress_pro_theme_options[client_content_page_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Page %d', 'corpopress-pro' ), $i ),
		'section'           => 'corpopress_pro_client_section',
		'choices'			=> corpopress_pro_page_choices(),
		'active_callback'	=> 'corpopress_pro_is_client_section_content_page_enable',
	) ) );

	// client posts drop down chooser control and setting
	$wp_customize->add_setting( 'corpopress_pro_theme_options[client_content_post_' . $i . ']', array(
		'sanitize_callback' => 'corpopress_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Corpopress_Pro_Dropdown_Chooser( $wp_customize, 'corpopress_pro_theme_options[client_content_post_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Post %d', 'corpopress-pro' ), $i ),
		'section'           => 'corpopress_pro_client_section',
		'choices'			=> corpopress_pro_post_choices(),
		'active_callback'	=> 'corpopress_pro_is_client_section_content_post_enable',
	) ) );

	// client image setting and control.
	$wp_customize->add_setting( 'corpopress_pro_theme_options[client_image_' . $i . ']', array(
		'sanitize_callback' => 'corpopress_pro_sanitize_image'
	) );

	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'corpopress_pro_theme_options[client_image_' . $i . ']',
			array(
			'label'       		=> sprintf( esc_html__( 'Image %d', 'corpopress-pro' ), $i ),
			'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'corpopress-pro' ), 200, 125 ),
			'section'     		=> 'corpopress_pro_client_section',
			'active_callback'	=> 'corpopress_pro_is_client_section_content_custom_enable',
	) ) );

	// client alt text setting and control
	$wp_customize->add_setting( 'corpopress_pro_theme_options[client_title_' . $i . ']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'corpopress_pro_theme_options[client_title_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Alternative Text %d', 'corpopress-pro' ), $i ),
		'section'        	=> 'corpopress_pro_client_section',
		'active_callback' 	=> 'corpopress_pro_is_client_section_content_custom_enable',
		'type'				=> 'text',
	) );

	// client position setting and control
	$wp_customize->add_setting( 'corpopress_pro_theme_options[client_link_' . $i . ']', array(
		'sanitize_callback' => 'esc_url_raw',
	) );

	$wp_customize->add_control( 'corpopress_pro_theme_options[client_link_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'URL Link %d', 'corpopress-pro' ), $i ),
		'section'        	=> 'corpopress_pro_client_section',
		'active_callback' 	=> 'corpopress_pro_is_client_section_content_custom_enable',
		'type'				=> 'url',
	) );

	// client hr setting and control
	$wp_customize->add_setting( 'corpopress_pro_theme_options[client_hr_'. $i .']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new Corpopress_Pro_Customize_Horizontal_Line( $wp_customize, 'corpopress_pro_theme_options[client_hr_'. $i .']',
		array(
			'section'         => 'corpopress_pro_client_section',
			'active_callback' => 'corpopress_pro_is_client_section_content_custom_enable',
			'type'			  => 'hr'
	) ) );
endfor;

