<?php
/**
 * collection Section options
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */

if ( !class_exists('WooCommerce') ) {
    return;
}

// Add collection section
$wp_customize->add_section( 'corpopress_pro_collection_section', array(
	'title'             => esc_html__( 'Products Collection','corpopress-pro' ),
	'description'       => esc_html__( 'Note: To activate this section you need to install WooCommerce Plugin.', 'corpopress-pro' ),
	'panel'             => 'corpopress_pro_front_page_panel',
	'active_callback'   => function( $control ) {
        return ( 
        	corpopress_pro_is_fourth_layout( $control )
        );
    },
) );

// collection content enable control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[collection_section_enable]', array(
	'default'			=> 	$options['collection_section_enable'],
	'sanitize_callback' => 'corpopress_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Corpopress_Pro_Switch_Control( $wp_customize, 'corpopress_pro_theme_options[collection_section_enable]', array(
	'label'             => esc_html__( 'collection Section Enable', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_collection_section',
	'on_off_label' 		=> corpopress_pro_switch_options(),
) ) );

// Event social icons number control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[collection_count]', array(
	'default'          	=> $options['collection_count'],
	'sanitize_callback' => 'corpopress_pro_sanitize_number_range',
	'validate_callback' => 'corpopress_pro_validate_collection_count',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[collection_count]', array(
	'label'             => esc_html__( 'Number of Collections', 'corpopress-pro' ),
	'description'       => esc_html__( 'Note: Min 1 & Max 50. Please input the valid number and save. Then refresh the page to see the change.', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_collection_section',
	'active_callback'   => 'corpopress_pro_is_collection_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'max'	=> 50,
		'style' => 'width: 100px;'
		),
) );

for ( $i = 1; $i <= $options['collection_count']; $i++ ) :

	// Add dropdown category setting and control.
	$wp_customize->add_setting(  'corpopress_pro_theme_options[collection_content_product_category_'.$i.']', array(
		'sanitize_callback' => 'absint',
	) ) ;

	$wp_customize->add_control( new Corpopress_Pro_Dropdown_Taxonomies_Control( $wp_customize,'corpopress_pro_theme_options[collection_content_product_category_'.$i.']', array(
		'label'             => esc_html__( 'Select collection Category ', 'corpopress-pro' ).$i,
		'section'           => 'corpopress_pro_collection_section',
		'taxonomy'			=> 'product_cat',
		'type'              => 'dropdown-taxonomies',
		'active_callback'	=> 'corpopress_pro_is_collection_section_enable'
	) ) );

endfor;