<?php
/**
 * Counter Section options
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */

// Add Counter section
$wp_customize->add_section( 'corpopress_pro_counter_section', array(
	'title'             => esc_html__( 'Counter','corpopress-pro' ),
	'description'       => esc_html__( 'Counter Section options.', 'corpopress-pro' ),
	'panel'             => 'corpopress_pro_front_page_panel',
	'active_callback'   => function( $control ) {
        return ( 
            corpopress_pro_is_default_layout( $control )
        );
    },
) );

// Counter content enable control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[counter_section_enable]', array(
	'default'			=> 	$options['counter_section_enable'],
	'sanitize_callback' => 'corpopress_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Corpopress_Pro_Switch_Control( $wp_customize, 'corpopress_pro_theme_options[counter_section_enable]', array(
	'label'             => esc_html__( 'Counter Section Enable', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_counter_section',
	'on_off_label' 		=> corpopress_pro_switch_options(),
) ) );

for ( $i = 1; $i <= 4; $i++ ) :

	// counter note control and setting
	$wp_customize->add_setting( 'corpopress_pro_theme_options[counter_icon_' . $i . ']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( new Corpopress_Pro_Icon_Picker( $wp_customize, 'corpopress_pro_theme_options[counter_icon_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Icon %d', 'corpopress-pro' ), $i ),
		'section'           => 'corpopress_pro_counter_section',
		'active_callback'	=> 'corpopress_pro_is_counter_section_enable',
	) ) );

	// counter title setting and control
	$wp_customize->add_setting( 'corpopress_pro_theme_options[counter_title_' . $i . ']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'corpopress_pro_theme_options[counter_title_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Title %d', 'corpopress-pro' ), $i ),
		'section'        	=> 'corpopress_pro_counter_section',
		'active_callback' 	=> 'corpopress_pro_is_counter_section_enable',
		'type'				=> 'text',
	) );

	// counter title setting and control
	$wp_customize->add_setting( 'corpopress_pro_theme_options[counter_value_' . $i . ']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'corpopress_pro_theme_options[counter_value_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Value %d', 'corpopress-pro' ), $i ),
		'section'        	=> 'corpopress_pro_counter_section',
		'active_callback' 	=> 'corpopress_pro_is_counter_section_enable',
		'type'				=> 'text',
	) );


	// counter hr setting and control
	$wp_customize->add_setting( 'corpopress_pro_theme_options[counter_hr_'. $i .']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new Corpopress_Pro_Customize_Horizontal_Line( $wp_customize, 'corpopress_pro_theme_options[counter_hr_'. $i .']',
		array(
			'section'         => 'corpopress_pro_counter_section',
			'active_callback' => 'corpopress_pro_is_counter_section_enable',
			'type'			  => 'hr'
	) ) );
endfor;

