<?php
/**
 * featured_products Section options
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */

if ( !class_exists('WooCommerce') ) {
    return;
}

// Add featured_products section
$wp_customize->add_section( 'corpopress_pro_featured_products_section', array(
	'title'             => esc_html__( 'Featured Products','corpopress-pro' ),
	'description'       => esc_html__( 'Note: To activate this section you need to install WooCommerce Plugin.', 'corpopress-pro' ),
	'panel'             => 'corpopress_pro_front_page_panel',
	'active_callback'   => function( $control ) {
        return (
        	corpopress_pro_is_fourth_layout( $control )
        	);
    },
) );

// featured_products content enable control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[featured_products_section_enable]', array(
	'default'			=> 	$options['featured_products_section_enable'],
	'sanitize_callback' => 'corpopress_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Corpopress_Pro_Switch_Control( $wp_customize, 'corpopress_pro_theme_options[featured_products_section_enable]', array(
	'label'             => esc_html__( 'Featured Products Section Enable', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_featured_products_section',
	'on_off_label' 		=> corpopress_pro_switch_options(),
) ) );

if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'corpopress_pro_theme_options[featured_products_section_enable]', array(
		'selector'            => '#featured-products .tooltiptext',
		'settings'            => 'corpopress_pro_theme_options[featured_products_section_enable]',
    ) );
}

// content type control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[featured_products_count]', array(
	'default'          	=> $options['featured_products_count'],
	'sanitize_callback' => 'corpopress_pro_sanitize_number_range',
	'validate_callback' => 'corpopress_pro_validate_featured_products_count',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[featured_products_count]', array(
	'label'             => esc_html__( 'Number of Posts', 'corpopress-pro' ),
	'description'       => esc_html__( 'Note: Min 2 & Max 30. Please input the valid number and save. Then refresh the page to see the change.', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_featured_products_section',
	'active_callback'   => 'corpopress_pro_is_featured_products_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 2,
		'max'	=> 30,
		'style' => 'width: 100px;'
		),
) );

for ( $i = 1; $i <= $options['featured_products_count']; $i++ ) :

	// Add dropdown category setting and control.
	$wp_customize->add_setting(  'corpopress_pro_theme_options[featured_products_content_product_category_'.$i.']', array(
		'sanitize_callback' => 'absint',
	) ) ;

	$wp_customize->add_control( new Corpopress_Pro_Dropdown_Taxonomies_Control( $wp_customize,'corpopress_pro_theme_options[featured_products_content_product_category_'.$i.']', array(
		'label'             => esc_html__( 'Select Featured Products Category ', 'corpopress-pro' ).$i,
		'section'           => 'corpopress_pro_featured_products_section',
		'taxonomy'			=> 'product_cat',
		'type'              => 'dropdown-taxonomies',
		'active_callback'	=> 'corpopress_pro_is_featured_products_section_enable'
	) ) );

	$wp_customize->add_setting( 'corpopress_pro_theme_options[featured_products_banner_title_'.$i.']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'corpopress_pro_theme_options[featured_products_banner_title_'.$i.']', array(
		'label'           	=> esc_html__( 'Featured Product Title ', 'corpopress-pro' ).$i,
		'section'        	=> 'corpopress_pro_featured_products_section',
		'active_callback' 	=> 'corpopress_pro_is_featured_products_section_enable',
		'type'				=> 'text',
	) );

	$wp_customize->add_setting( 'corpopress_pro_theme_options[featured_products_banner_description_'.$i.']', array(
		'sanitize_callback' => 'wp_kses_post',
	) );

	$wp_customize->add_control( 'corpopress_pro_theme_options[featured_products_banner_description_'.$i.']', array(
		'label'           	=> esc_html__( 'Featured Product Description ', 'corpopress-pro' ).$i,
		'section'        	=> 'corpopress_pro_featured_products_section',
		'active_callback' 	=> 'corpopress_pro_is_featured_products_section_enable',
		'type'				=> 'textarea',
	) );

	$wp_customize->add_setting( 'corpopress_pro_theme_options[featured_products_button_'.$i.']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'corpopress_pro_theme_options[featured_products_button_'.$i.']', array(
		'label'           	=> esc_html__( 'Button Label ', 'corpopress-pro' ).$i,
		'section'        	=> 'corpopress_pro_featured_products_section',
		'active_callback' 	=> 'corpopress_pro_is_featured_products_section_enable',
		'type'				=> 'text',
	) );

	// featured_products hr setting and control
	$wp_customize->add_setting( 'corpopress_pro_theme_options[featured_products_hr_'. $i .']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new Corpopress_Pro_Customize_Horizontal_Line( $wp_customize, 'corpopress_pro_theme_options[featured_products_hr_'. $i .']',
		array(
			'section'         => 'corpopress_pro_featured_products_section',
			'active_callback' => 'corpopress_pro_is_featured_products_section_enable',
			'type'			  => 'hr'
	) ) );

endfor;