<?php
/**
 * Featured Section options
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */

// Add Featured section
$wp_customize->add_section( 'corpopress_pro_featured_section', array(
	'title'             => esc_html__( 'Featured','corpopress-pro' ),
	'description'       => esc_html__( 'Featured Section options.', 'corpopress-pro' ),
	'panel'             => 'corpopress_pro_front_page_panel',
	'active_callback'   => function( $control ) {
        return ( 
            corpopress_pro_is_default_layout( $control )
            ||
            corpopress_pro_is_second_layout( $control )
        );
    },
) );

// Featured content enable control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[featured_section_enable]', array(
	'default'			=> 	$options['featured_section_enable'],
	'sanitize_callback' => 'corpopress_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Corpopress_Pro_Switch_Control( $wp_customize, 'corpopress_pro_theme_options[featured_section_enable]', array(
	'label'             => esc_html__( 'Featured Section Enable', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_featured_section',
	'on_off_label' 		=> corpopress_pro_switch_options(),
) ) );

// Featured content type control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[featured_content_type]', array(
	'default'          	=> $options['featured_content_type'],
	'sanitize_callback' => 'corpopress_pro_sanitize_select',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[featured_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_featured_section',
	'type'				=> 'select',
	'active_callback' 	=> 'corpopress_pro_is_featured_section_enable',
	'choices'			=> array( 
		'page' 		=> esc_html__( 'Page', 'corpopress-pro' ),
		'post' 		=> esc_html__( 'Post', 'corpopress-pro' ),
		'category' 	=> esc_html__( 'Category', 'corpopress-pro' ),
	),
) );

// Event social icons number control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[featured_count]', array(
	'default'          	=> $options['featured_count'],
	'sanitize_callback' => 'corpopress_pro_sanitize_number_range',
	'validate_callback' => 'corpopress_pro_validate_featured_count',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[featured_count]', array(
	'label'             => esc_html__( 'Number of Slides', 'corpopress-pro' ),
	'description'       => esc_html__( 'Note: Min 1 & Max 10. Please input the valid number and save. Then refresh the page to see the change.', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_featured_section',
	'active_callback'   => 'corpopress_pro_is_featured_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'max'	=> 10,
		'style' => 'width: 100px;'
		),
) );

for ( $i = 1; $i <= $options['featured_count']; $i++ ) :
	// featured pages drop down chooser control and setting
	$wp_customize->add_setting( 'corpopress_pro_theme_options[featured_content_page_' . $i . ']', array(
		'sanitize_callback' => 'corpopress_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Corpopress_Pro_Dropdown_Chooser( $wp_customize, 'corpopress_pro_theme_options[featured_content_page_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Page %d', 'corpopress-pro' ), $i ),
		'section'           => 'corpopress_pro_featured_section',
		'choices'			=> corpopress_pro_page_choices(),
		'active_callback'	=> 'corpopress_pro_is_featured_section_content_page_enable',
	) ) );

	// featured posts drop down chooser control and setting
	$wp_customize->add_setting( 'corpopress_pro_theme_options[featured_content_post_' . $i . ']', array(
		'sanitize_callback' => 'corpopress_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Corpopress_Pro_Dropdown_Chooser( $wp_customize, 'corpopress_pro_theme_options[featured_content_post_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Post %d', 'corpopress-pro' ), $i ),
		'section'           => 'corpopress_pro_featured_section',
		'choices'			=> corpopress_pro_post_choices(),
		'active_callback'	=> 'corpopress_pro_is_featured_section_content_post_enable',
	) ) );
endfor;

// Add dropdown category setting and control.
$wp_customize->add_setting(  'corpopress_pro_theme_options[featured_content_category]', array(
	'sanitize_callback' => 'corpopress_pro_sanitize_single_category',
) ) ;

$wp_customize->add_control( new Corpopress_Pro_Dropdown_Taxonomies_Control( $wp_customize,'corpopress_pro_theme_options[featured_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'corpopress-pro' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_featured_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'corpopress_pro_is_featured_section_content_category_enable'
) ) );
