<?php 

$wp_customize->add_section( 'corpopress_pro_home_layout', array(
	'title'             => esc_html__( 'Home Page Layout','corpopress-pro' ),
	'description'       => esc_html__( 'Home Page Layout option.', 'corpopress-pro' ),
	'panel'             => 'corpopress_pro_front_page_panel',
) );


$wp_customize->add_setting( 'corpopress_pro_theme_options[home_layout]', array(
		'default'           => $options['home_layout'],
		'sanitize_callback' => 'corpopress_pro_sanitize_select',
		'transport'			=> 'refresh'
	) );

$wp_customize->add_control( 'corpopress_pro_theme_options[home_layout]', array(
	'type'				=> 'radio',
	'label'             => esc_html__( 'Select Homepage layout', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_home_layout',
	'choices'				=> array(
		'default-design'     	 => esc_html__( 'Pro Design', 'corpopress-pro' ),
		'second-design'      	 => esc_html__( 'Blog Design', 'corpopress-pro' ),
		'third-design'      	 => esc_html__( 'Magazine Design', 'corpopress-pro' ),
		'fourth-design'      	 => esc_html__( 'Shop Design', 'corpopress-pro' ),
		)
) );

foreach ( array( 'default', 'second', 'third', 'fourth' ) as $list) {
	// Site layout setting and control.
	$wp_customize->add_setting( 'corpopress_pro_theme_options['.$list.'_sortable]', array(
		'default'			  => $options[$list.'_sortable'],
		'sanitize_callback'   => 'corpopress_pro_sanitize_sortable',
	) );

	$wp_customize->add_control( new Corpopress_Pro_Customize_Sortable_Control ( $wp_customize, 'corpopress_pro_theme_options['.$list.'_sortable]', array(
		'label'               => esc_html__( 'Sortable Homepage', 'corpopress-pro' ),
		'description'         => esc_html__( 'Drag and Drop to sort the sections according to your preference.', 'corpopress-pro' ),
		'section'             => 'corpopress_pro_home_layout',
		'type'                => 'sortable',
		'choices'			  => corpopress_pro_sortable_sections(),
		'active_callback'	  => 'corpopress_pro_is_'.$list.'_layout'

	) ) );
}
