<?php
/**
 * Latest Products Section options
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */
if ( !class_exists('WooCommerce') ) {
    return;
}

// Add recent_products section
$wp_customize->add_section( 'corpopress_pro_latest_products_section', array(
    'title'             => esc_html__( 'Latest Products','corpopress-pro' ),
    'description'       => esc_html__( 'Note: To activate this section you need to install WooCommerce Plugin.', 'corpopress-pro' ),
    'panel'             => 'corpopress_pro_front_page_panel',
    'active_callback'   => function( $control ) {
        return ( 
            corpopress_pro_is_fourth_layout( $control )  
        );
    },
) );

// recent_products content enable control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[latest_products_section_enable]', array(
    'default'           =>  $options['latest_products_section_enable'],
    'sanitize_callback' => 'corpopress_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Corpopress_Pro_Switch_Control( $wp_customize, 'corpopress_pro_theme_options[latest_products_section_enable]', array(
    'label'             => esc_html__( 'Latest product Section Enable', 'corpopress-pro' ),
    'section'           => 'corpopress_pro_latest_products_section',
    'on_off_label'      => corpopress_pro_switch_options(),
) ) );

// recent_products title setting and control
$wp_customize->add_setting( 'corpopress_pro_theme_options[latest_products_button]', array(
    'sanitize_callback' => 'sanitize_text_field',
    'default'           => $options['latest_products_button'],
    'transport'         => 'postMessage',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[latest_products_button]', array(
    'label'             => esc_html__( 'Button Label', 'corpopress-pro' ),
    'section'           => 'corpopress_pro_latest_products_section',
    'active_callback'   => 'corpopress_pro_is_latest_products_section_enable',
    'type'              => 'text',
) );
// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'corpopress_pro_theme_options[latest_products_button]', array(
        'selector'            => '#corpopress_pro_latest_products_section h2.section-title',
        'settings'            => 'corpopress_pro_theme_options[latest_products_button]',
        'container_inclusive' => false,
        'fallback_refresh'    => true,
        'render_callback'     => 'corpopress_pro_latest_products_button_partial',
    ) );
}

$wp_customize->add_setting( 'corpopress_pro_theme_options[latest_products_count]', array(
    'default'           => $options['latest_products_count'],
    'sanitize_callback' => 'corpopress_pro_sanitize_number_range',
    'validate_callback' => 'corpopress_pro_validate_latest_products_count',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[latest_products_count]', array(
    'label'             => esc_html__( 'Number of Products', 'corpopress-pro' ),
    'description'       => esc_html__( 'Note: Min 1 & Max 50. Please input the valid number and save. Then refresh the page to see the change.', 'corpopress-pro' ),
    'section'           => 'corpopress_pro_latest_products_section',
    'active_callback'   => 'corpopress_pro_is_latest_products_section_enable',
    'type'              => 'number',
    'input_attrs'       => array(
        'min'   => 1,
        'max'   => 50,
        'style' => 'width: 100px;'
        ),
) );

$wp_customize->add_setting( 'corpopress_pro_theme_options[latest_products_col_layout]', array(
    'default'           => $options['latest_products_col_layout'],
    'sanitize_callback' => 'corpopress_pro_sanitize_select',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[latest_products_col_layout]', array(
    'label'             => esc_html__( 'Column Layout', 'corpopress-pro' ),
    'section'           => 'corpopress_pro_latest_products_section',
    'type'              => 'select',
    'active_callback'   => 'corpopress_pro_is_latest_products_section_enable',
    'choices'           => array(
        'col-2'     => esc_html__( 'Two Column', 'corpopress-pro' ),
        'col-3' 	=> esc_html__( 'Three Column', 'corpopress-pro' ),
        'col-4'  	=> esc_html__( 'Four Column', 'corpopress-pro' ),
        ),
) );

$wp_customize->add_setting( 'corpopress_pro_theme_options[latest_products_content_type]', array(
    'default'           => $options['latest_products_content_type'],
    'sanitize_callback' => 'corpopress_pro_sanitize_select',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[latest_products_content_type]', array(
    'label'             => esc_html__( 'Content Type', 'corpopress-pro' ),
    'section'           => 'corpopress_pro_latest_products_section',
    'type'              => 'select',
    'active_callback'   => 'corpopress_pro_is_latest_products_section_enable',
    'choices'           => array(
        'product'           => esc_html__( 'Product', 'corpopress-pro' ),
        'product-category'  => esc_html__( 'Product Category', 'corpopress-pro' ),
        ),
) );

for( $i = 1 ; $i <= $options['latest_products_count']; $i++ ){

	// recent_products title setting and control
$wp_customize->add_setting( 'corpopress_pro_theme_options[latest_products_sub_title_' . $i . ']', array(
    'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[latest_products_sub_title_' . $i . ']', array(
    'label'             => sprintf( esc_html__( 'Sub Title %d', 'corpopress-pro' ), $i ),
    'section'           => 'corpopress_pro_latest_products_section',
    'active_callback'   => 'corpopress_pro_is_latest_products_section_enable',
    'type'              => 'text',
) );

    $wp_customize->add_setting( 'corpopress_pro_theme_options[latest_products_content_product_' . $i . ']', array(
        'sanitize_callback' => 'corpopress_pro_sanitize_page',
    ) );

    $wp_customize->add_control( new Corpopress_Pro_Dropdown_Chooser( $wp_customize, 'corpopress_pro_theme_options[latest_products_content_product_' . $i . ']', array(
        'label'             => sprintf( esc_html__( 'Select Product %d', 'corpopress-pro' ), $i ),
        'section'           => 'corpopress_pro_latest_products_section',
        'choices'           => corpopress_pro_product_choices(),
        'active_callback'   => 'corpopress_pro_is_latest_products_section_content_product_enable',
    ) ) );
}

$wp_customize->add_setting(  'corpopress_pro_theme_options[latest_products_content_product_category]', array(
        'sanitize_callback' => 'absint',
    ) ) ;

$wp_customize->add_control( new Corpopress_Pro_Dropdown_Taxonomies_Control( $wp_customize,'corpopress_pro_theme_options[latest_products_content_product_category]', array(
    'label'             => esc_html__( 'Select Product Categories', 'corpopress-pro' ),
    'description'       => esc_html__( 'Note: Press CTRL and select multiple category. Latest four posts will be shown from each selected category', 'corpopress-pro' ),
    'section'           => 'corpopress_pro_latest_products_section',
    'taxonomy'          => 'product_cat',
    'type'              => 'dropdown-taxonomies',
    'active_callback'   => 'corpopress_pro_is_latest_products_section_content_product_category_enable',
) ) );