<?php
/**
 * Politics  Section options
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */

// Add Politics  section
$wp_customize->add_section( 'corpopress_pro_politics_section', array(
	'title'             => esc_html__( 'Politics Posts','corpopress-pro' ),
	'description'       => esc_html__( 'Politics Section options.', 'corpopress-pro' ),
	'panel'             => 'corpopress_pro_front_page_panel',
	'active_callback'   => function( $control ) {
        return (
            corpopress_pro_is_third_layout( $control )
        );
    },
) );

// Politics  content enable control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[politics_section_enable]', array(
	'default'			=> 	$options['politics_section_enable'],
	'sanitize_callback' => 'corpopress_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Corpopress_Pro_Switch_Control( $wp_customize, 'corpopress_pro_theme_options[politics_section_enable]', array(
	'label'             => esc_html__( 'Politics  Section Enable', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_politics_section',
	'on_off_label' 		=> corpopress_pro_switch_options(),
) ) );

// politics title setting and control
$wp_customize->add_setting( 'corpopress_pro_theme_options[politics_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['politics_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[politics_title]', array(
	'label'           	=> esc_html__( 'Title', 'corpopress-pro' ),
	'section'        	=> 'corpopress_pro_politics_section',
	'active_callback' 	=> 'corpopress_pro_is_politics_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'corpopress_pro_theme_options[politics_title]', array(
		'selector'            => '#magazine-poltics-posts h2.section-title',
		'settings'            => 'corpopress_pro_theme_options[politics_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'corpopress_pro_politics_title_partial',
    ) );
}

// Politics  content type control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[politics_content_type]', array(
	'default'          	=> $options['politics_content_type'],
	'sanitize_callback' => 'corpopress_pro_sanitize_select',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[politics_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_politics_section',
	'type'				=> 'select',
	'active_callback' 	=> 'corpopress_pro_is_politics_section_enable',
	'choices'			=> array( 
		'page' 		=> esc_html__( 'Page', 'corpopress-pro' ),
		'post' 		=> esc_html__( 'Post', 'corpopress-pro' ),
		'category' 	=> esc_html__( 'Category', 'corpopress-pro' ),
	),
) );

// Event social icons number control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[politics_count]', array(
	'default'          	=> $options['politics_count'],
	'sanitize_callback' => 'corpopress_pro_sanitize_number_range',
	'validate_callback' => 'corpopress_pro_validate_politics_count',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[politics_count]', array(
	'label'             => esc_html__( 'Number of Posts', 'corpopress-pro' ),
	'description'       => esc_html__( 'Note: Min 1 & Max 50. Please input the valid number and save. Then refresh the page to see the change.', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_politics_section',
	'active_callback'   => 'corpopress_pro_is_politics_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'max'	=> 50,
		'style' => 'width: 100px;'
		),
) );

for ( $i = 1; $i <= $options['politics_count']; $i++ ) :
	// politics pages drop down chooser control and setting
	$wp_customize->add_setting( 'corpopress_pro_theme_options[politics_content_page_' . $i . ']', array(
		'sanitize_callback' => 'corpopress_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Corpopress_Pro_Dropdown_Chooser( $wp_customize, 'corpopress_pro_theme_options[politics_content_page_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Page %d', 'corpopress-pro' ), $i ),
		'section'           => 'corpopress_pro_politics_section',
		'choices'			=> corpopress_pro_page_choices(),
		'active_callback'	=> 'corpopress_pro_is_politics_section_content_page_enable',
	) ) );

	// politics posts drop down chooser control and setting
	$wp_customize->add_setting( 'corpopress_pro_theme_options[politics_content_post_' . $i . ']', array(
		'sanitize_callback' => 'corpopress_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Corpopress_Pro_Dropdown_Chooser( $wp_customize, 'corpopress_pro_theme_options[politics_content_post_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Post %d', 'corpopress-pro' ), $i ),
		'section'           => 'corpopress_pro_politics_section',
		'choices'			=> corpopress_pro_post_choices(),
		'active_callback'	=> 'corpopress_pro_is_politics_section_content_post_enable',
	) ) );
endfor;

// Add dropdown category setting and control.
$wp_customize->add_setting(  'corpopress_pro_theme_options[politics_content_category]', array(
	'sanitize_callback' => 'corpopress_pro_sanitize_single_category',
) ) ;

$wp_customize->add_control( new Corpopress_Pro_Dropdown_Taxonomies_Control( $wp_customize,'corpopress_pro_theme_options[politics_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'corpopress-pro' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_politics_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'corpopress_pro_is_politics_section_content_category_enable'
) ) );