<?php
/**
 * Popular Products Section options
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */
if ( !class_exists('WooCommerce') ) {
    return;
}

// Add recent_products section
$wp_customize->add_section( 'corpopress_pro_popular_products_section', array(
    'title'             => esc_html__( 'Popular Products','corpopress-pro' ),
    'description'       => esc_html__( 'Note: To activate this section you need to install WooCommerce Plugin.', 'corpopress-pro' ),
    'panel'             => 'corpopress_pro_front_page_panel',
    'active_callback'   => function( $control ) {
        return ( 
            corpopress_pro_is_fourth_layout( $control )  
        );
    },
) );

// recent_products content enable control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[popular_products_section_enable]', array(
    'default'           =>  $options['popular_products_section_enable'],
    'sanitize_callback' => 'corpopress_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Corpopress_Pro_Switch_Control( $wp_customize, 'corpopress_pro_theme_options[popular_products_section_enable]', array(
    'label'             => esc_html__( 'Popular product Section Enable', 'corpopress-pro' ),
    'section'           => 'corpopress_pro_popular_products_section',
    'on_off_label'      => corpopress_pro_switch_options(),
) ) );

// recent_products title setting and control
$wp_customize->add_setting( 'corpopress_pro_theme_options[popular_products_sub_title]', array(
    'sanitize_callback' => 'sanitize_text_field',
    'default'           => $options['popular_products_sub_title'],       
    'transport'         => 'postMessage',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[popular_products_sub_title]', array(
    'label'             => esc_html__( 'Sub Title', 'corpopress-pro' ),
    'section'           => 'corpopress_pro_popular_products_section',
    'active_callback'   => 'corpopress_pro_is_popular_products_section_enable',
    'type'              => 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'corpopress_pro_theme_options[popular_products_sub_title]', array(
        'selector'            => '#popular-products p.section-subtitle',
        'settings'            => 'corpopress_pro_theme_options[popular_products_sub_title]',
        'container_inclusive' => false,
        'fallback_refresh'    => true,
        'render_callback'     => 'corpopress_pro_popular_products_sub_title_partial',
    ) );
}

// recent_products title setting and control
$wp_customize->add_setting( 'corpopress_pro_theme_options[popular_products_title]', array(
    'sanitize_callback' => 'sanitize_text_field',
    'default'           => $options['popular_products_title'],
    'transport'         => 'postMessage',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[popular_products_title]', array(
    'label'             => esc_html__( 'Title', 'corpopress-pro' ),
    'section'           => 'corpopress_pro_popular_products_section',
    'active_callback'   => 'corpopress_pro_is_popular_products_section_enable',
    'type'              => 'text',
) );
// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'corpopress_pro_theme_options[popular_products_title]', array(
        'selector'            => '#popular-products h2.section-title',
        'settings'            => 'corpopress_pro_theme_options[popular_products_title]',
        'container_inclusive' => false,
        'fallback_refresh'    => true,
        'render_callback'     => 'corpopress_pro_popular_products_title_partial',
    ) );
}

$wp_customize->add_setting( 'corpopress_pro_theme_options[popular_products_count]', array(
    'default'           => $options['popular_products_count'],
    'sanitize_callback' => 'corpopress_pro_sanitize_number_range',
    'validate_callback' => 'corpopress_pro_validate_popular_products_count',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[popular_products_count]', array(
    'label'             => esc_html__( 'Number of Products', 'corpopress-pro' ),
    'description'       => esc_html__( 'Note: Min 1 & Max 50. Please input the valid number and save. Then refresh the page to see the change.', 'corpopress-pro' ),
    'section'           => 'corpopress_pro_popular_products_section',
    'active_callback'   => 'corpopress_pro_is_popular_products_section_enable',
    'type'              => 'number',
    'input_attrs'       => array(
        'min'   => 1,
        'max'   => 50,
        'style' => 'width: 100px;'
        ),
) );

$wp_customize->add_setting( 'corpopress_pro_theme_options[popular_products_content_type]', array(
    'default'           => $options['popular_products_content_type'],
    'sanitize_callback' => 'corpopress_pro_sanitize_select',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[popular_products_content_type]', array(
    'label'             => esc_html__( 'Content Type', 'corpopress-pro' ),
    'section'           => 'corpopress_pro_popular_products_section',
    'type'              => 'select',
    'active_callback'   => 'corpopress_pro_is_popular_products_section_enable',
    'choices'           => array(
        'product'           => esc_html__( 'Product', 'corpopress-pro' ),
        'product-category'  => esc_html__( 'Product Category', 'corpopress-pro' ),
        ),
) );

for( $i = 1 ; $i <= $options['popular_products_count']; $i++ ){

    $wp_customize->add_setting( 'corpopress_pro_theme_options[popular_products_content_product_' . $i . ']', array(
        'sanitize_callback' => 'corpopress_pro_sanitize_page',
    ) );

    $wp_customize->add_control( new Corpopress_Pro_Dropdown_Chooser( $wp_customize, 'corpopress_pro_theme_options[popular_products_content_product_' . $i . ']', array(
        'label'             => sprintf( esc_html__( 'Select Product %d', 'corpopress-pro' ), $i ),
        'section'           => 'corpopress_pro_popular_products_section',
        'choices'           => corpopress_pro_product_choices(),
        'active_callback'   => 'corpopress_pro_is_popular_products_section_content_product_enable',
    ) ) );
}

$wp_customize->add_setting(  'corpopress_pro_theme_options[popular_products_content_product_category]', array(
        'sanitize_callback' => 'absint',
    ) ) ;

$wp_customize->add_control( new Corpopress_Pro_Dropdown_Taxonomies_Control( $wp_customize,'corpopress_pro_theme_options[popular_products_content_product_category]', array(
    'label'             => esc_html__( 'Select Product Categories', 'corpopress-pro' ),
    'description'       => esc_html__( 'Note: Press CTRL and select multiple category. Latest four posts will be shown from each selected category', 'corpopress-pro' ),
    'section'           => 'corpopress_pro_popular_products_section',
    'taxonomy'          => 'product_cat',
    'type'              => 'dropdown-taxonomies',
    'active_callback'   => 'corpopress_pro_is_popular_products_section_content_product_category_enable',
) ) );