<?php
/**
 * Popular Posts Section options
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */

// Add Popular Posts section
$wp_customize->add_section( 'corpopress_pro_popular_section', array(
	'title'             => esc_html__( 'Popular Posts','corpopress-pro' ),
	'description'       => esc_html__( 'Popular Posts Section options.', 'corpopress-pro' ),
	'panel'             => 'corpopress_pro_front_page_panel',
	'active_callback'   => function( $control ) {
        return ( 
            corpopress_pro_is_second_layout( $control )
        );
    },
) );

// Popular Posts content enable control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[popular_section_enable]', array(
	'default'			=> 	$options['popular_section_enable'],
	'sanitize_callback' => 'corpopress_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Corpopress_Pro_Switch_Control( $wp_customize, 'corpopress_pro_theme_options[popular_section_enable]', array(
	'label'             => esc_html__( 'Popular Posts Section Enable', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_popular_section',
	'on_off_label' 		=> corpopress_pro_switch_options(),
) ) );

// popular title setting and control
$wp_customize->add_setting( 'corpopress_pro_theme_options[popular_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['popular_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[popular_title]', array(
	'label'           	=> esc_html__( 'Title', 'corpopress-pro' ),
	'section'        	=> 'corpopress_pro_popular_section',
	'active_callback' 	=> 'corpopress_pro_is_popular_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'corpopress_pro_theme_options[popular_title]', array(
		'selector'            => '#popular-posts-section h2.section-title',
		'settings'            => 'corpopress_pro_theme_options[popular_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'corpopress_pro_popular_title_partial',
    ) );
}

// Popular Posts content type control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[popular_content_type]', array(
	'default'          	=> $options['popular_content_type'],
	'sanitize_callback' => 'corpopress_pro_sanitize_select',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[popular_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_popular_section',
	'type'				=> 'select',
	'active_callback' 	=> 'corpopress_pro_is_popular_section_enable',
	'choices'			=> array( 
		'page' 		=> esc_html__( 'Page', 'corpopress-pro' ),
		'post' 		=> esc_html__( 'Post', 'corpopress-pro' ),
		'category' 	=> esc_html__( 'Category', 'corpopress-pro' ),
	),
) );

// Event social icons number control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[popular_excerpt]', array(
	'default'          	=> $options['popular_excerpt'],
	'sanitize_callback' => 'corpopress_pro_sanitize_number_range',
	'validate_callback' => 'corpopress_pro_validate_long_excerpt',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[popular_excerpt]', array(
	'label'             => esc_html__( 'Description Length', 'corpopress-pro' ),
	'description'       => esc_html__( 'Note: Min 1 & Max 100. Please input the valid number and save. Then refresh the page to see the change.', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_popular_section',
	'active_callback'   => 'corpopress_pro_is_popular_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'max'	=> 100,
		'style' => 'width: 100px;'
		),
) );

// Event social icons number control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[popular_count]', array(
	'default'          	=> $options['popular_count'],
	'sanitize_callback' => 'corpopress_pro_sanitize_number_range',
	'validate_callback' => 'corpopress_pro_validate_popular_count',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[popular_count]', array(
	'label'             => esc_html__( 'Number of Posts', 'corpopress-pro' ),
	'description'       => esc_html__( 'Note: Min 2 & Max 50. Please input the valid number and save. Then refresh the page to see the change.', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_popular_section',
	'active_callback'   => 'corpopress_pro_is_popular_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 2,
		'max'	=> 50,
		'style' => 'width: 100px;'
		),
) );

for ( $i = 1; $i <= $options['popular_count']; $i++ ) :
	// popular pages drop down chooser control and setting
	$wp_customize->add_setting( 'corpopress_pro_theme_options[popular_content_page_' . $i . ']', array(
		'sanitize_callback' => 'corpopress_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Corpopress_Pro_Dropdown_Chooser( $wp_customize, 'corpopress_pro_theme_options[popular_content_page_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Page %d', 'corpopress-pro' ), $i ),
		'section'           => 'corpopress_pro_popular_section',
		'choices'			=> corpopress_pro_page_choices(),
		'active_callback'	=> 'corpopress_pro_is_popular_section_content_page_enable',
	) ) );

	// popular posts drop down chooser control and setting
	$wp_customize->add_setting( 'corpopress_pro_theme_options[popular_content_post_' . $i . ']', array(
		'sanitize_callback' => 'corpopress_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Corpopress_Pro_Dropdown_Chooser( $wp_customize, 'corpopress_pro_theme_options[popular_content_post_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Post %d', 'corpopress-pro' ), $i ),
		'section'           => 'corpopress_pro_popular_section',
		'choices'			=> corpopress_pro_post_choices(),
		'active_callback'	=> 'corpopress_pro_is_popular_section_content_post_enable',
	) ) );
endfor;

// Add dropdown category setting and control.
$wp_customize->add_setting(  'corpopress_pro_theme_options[popular_content_category]', array(
	'sanitize_callback' => 'corpopress_pro_sanitize_single_category',
) ) ;

$wp_customize->add_control( new Corpopress_Pro_Dropdown_Taxonomies_Control( $wp_customize,'corpopress_pro_theme_options[popular_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'corpopress-pro' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_popular_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'corpopress_pro_is_popular_section_content_category_enable'
) ) );