<?php
/**
 * Promotion Section options
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */

// Add Promotion section
$wp_customize->add_section( 'corpopress_pro_promotion_section', array(
	'title'             => esc_html__( 'Promotion','corpopress-pro' ),
	'description'       => esc_html__( 'Promotion Section options.', 'corpopress-pro' ),
	'panel'             => 'corpopress_pro_front_page_panel',
	'active_callback'   => function( $control ) {
        return ( 
            corpopress_pro_is_default_layout( $control )
        );
    },
) );

// Promotion content enable control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[promotion_section_enable]', array(
	'default'			=> 	$options['promotion_section_enable'],
	'sanitize_callback' => 'corpopress_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Corpopress_Pro_Switch_Control( $wp_customize, 'corpopress_pro_theme_options[promotion_section_enable]', array(
	'label'             => esc_html__( 'Promotion Section Enable', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_promotion_section',
	'on_off_label' 		=> corpopress_pro_switch_options(),
) ) );

// Promotion content type control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[promotion_content_type]', array(
	'default'          	=> $options['promotion_content_type'],
	'sanitize_callback' => 'corpopress_pro_sanitize_select',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[promotion_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_promotion_section',
	'type'				=> 'select',
	'active_callback' 	=> 'corpopress_pro_is_promotion_section_enable',
	'choices'			=> array( 
		'page' 		=> esc_html__( 'Page', 'corpopress-pro' ),
		'post' 		=> esc_html__( 'Post', 'corpopress-pro' ),
		'custom' 	=> esc_html__( 'Custom', 'corpopress-pro' ),
	),
) );

// promotion pages drop down chooser control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[promotion_content_page]', array(
	'sanitize_callback' => 'corpopress_pro_sanitize_page',
) );

$wp_customize->add_control( new Corpopress_Pro_Dropdown_Chooser( $wp_customize, 'corpopress_pro_theme_options[promotion_content_page]', array(
	'label'             => esc_html__( 'Select Page', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_promotion_section',
	'choices'			=> corpopress_pro_page_choices(),
	'active_callback'	=> 'corpopress_pro_is_promotion_section_content_page_enable',
) ) );

// promotion posts drop down chooser control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[promotion_content_post]', array(
	'sanitize_callback' => 'corpopress_pro_sanitize_page',
) );

$wp_customize->add_control( new Corpopress_Pro_Dropdown_Chooser( $wp_customize, 'corpopress_pro_theme_options[promotion_content_post]', array(
	'label'             => esc_html__( 'Select Post', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_promotion_section',
	'choices'			=> corpopress_pro_post_choices(),
	'active_callback'	=> 'corpopress_pro_is_promotion_section_content_post_enable',
) ) );

// promotion title setting and control
$wp_customize->add_setting( 'corpopress_pro_theme_options[promotion_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['promotion_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[promotion_title]', array(
	'label'           	=> esc_html__( 'Title', 'corpopress-pro' ),
	'section'        	=> 'corpopress_pro_promotion_section',
	'active_callback' 	=> 'corpopress_pro_is_promotion_section_content_custom_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'corpopress_pro_theme_options[promotion_title]', array(
		'selector'            => '#latest .entry-container .section-header h2.section-title',
		'settings'            => 'corpopress_pro_theme_options[promotion_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'corpopress_pro_promotion_title_partial',
    ) );
}

// promotion description setting and control
$wp_customize->add_setting( 'corpopress_pro_theme_options[promotion_description]', array(
	'sanitize_callback' => 'wp_kses_post',
	'default'			=> $options['promotion_description'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[promotion_description]', array(
	'label'           	=> esc_html__( 'Description', 'corpopress-pro' ),
	'section'        	=> 'corpopress_pro_promotion_section',
	'active_callback' 	=> 'corpopress_pro_is_promotion_section_content_custom_enable',
	'type'				=> 'textarea',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'corpopress_pro_theme_options[promotion_description]', array(
		'selector'            => '#latest .section-content .entry-content p',
		'settings'            => 'corpopress_pro_theme_options[promotion_description]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'corpopress_pro_promotion_description_partial',
    ) );
}

// promotion image setting and control.
$wp_customize->add_setting( 'corpopress_pro_theme_options[promotion_image]', array(
	'sanitize_callback' => 'corpopress_pro_sanitize_image'
) );

$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'corpopress_pro_theme_options[promotion_image]',
		array(
		'label'       		=> esc_html__( 'Image', 'corpopress-pro' ),
		'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'corpopress-pro' ), 1280, 854 ),
		'section'     		=> 'corpopress_pro_promotion_section',
		'active_callback'	=> 'corpopress_pro_is_promotion_section_content_custom_enable',
) ) );

// promotion btn title setting and control
$wp_customize->add_setting( 'corpopress_pro_theme_options[promotion_btn_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['promotion_btn_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[promotion_btn_title]', array(
	'label'           	=> esc_html__( 'Button Label', 'corpopress-pro' ),
	'section'        	=> 'corpopress_pro_promotion_section',
	'active_callback' 	=> 'corpopress_pro_is_promotion_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'corpopress_pro_theme_options[promotion_btn_title]', array(
		'selector'            => '#latest a.btn-default',
		'settings'            => 'corpopress_pro_theme_options[promotion_btn_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'corpopress_pro_promotion_btn_title_partial',
    ) );
}

// promotion btn link setting and control
$wp_customize->add_setting( 'corpopress_pro_theme_options[promotion_btn_link]', array(
	'sanitize_callback' => 'esc_url_raw',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[promotion_btn_link]', array(
	'label'           	=> esc_html__( 'Button Link', 'corpopress-pro' ),
	'section'        	=> 'corpopress_pro_promotion_section',
	'active_callback' 	=> 'corpopress_pro_is_promotion_section_content_custom_enable',
	'type'				=> 'url',
) );

// promotion alt btn title setting and control
$wp_customize->add_setting( 'corpopress_pro_theme_options[promotion_alt_btn_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['promotion_alt_btn_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[promotion_alt_btn_title]', array(
	'label'           	=> esc_html__( 'Alt Button Label', 'corpopress-pro' ),
	'section'        	=> 'corpopress_pro_promotion_section',
	'active_callback' 	=> 'corpopress_pro_is_promotion_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'corpopress_pro_theme_options[promotion_alt_btn_title]', array(
		'selector'            => '#latest a.btn-transparent',
		'settings'            => 'corpopress_pro_theme_options[promotion_alt_btn_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'corpopress_pro_promotion_alt_btn_title_partial',
    ) );
}

// promotion alt btn url setting and control
$wp_customize->add_setting( 'corpopress_pro_theme_options[promotion_alt_btn_url]', array(
	'sanitize_callback' => 'esc_url_raw',
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[promotion_alt_btn_url]', array(
	'label'           	=> esc_html__( 'Alt Button Url', 'corpopress-pro' ),
	'section'        	=> 'corpopress_pro_promotion_section',
	'active_callback' 	=> 'corpopress_pro_is_promotion_section_enable',
	'type'				=> 'url',
) );
