<?php
/**
 * Service Section options
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */

// Add Service section
$wp_customize->add_section( 'corpopress_pro_service_section', array(
	'title'             => esc_html__( 'Services','corpopress-pro' ),
	'description'       => esc_html__( 'Services Section options.', 'corpopress-pro' ),
	'panel'             => 'corpopress_pro_front_page_panel',
	'active_callback'   => function( $control ) {
        return ( 
            corpopress_pro_is_default_layout( $control )
        );
    },
) );

// Service content enable control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[service_section_enable]', array(
	'default'			=> 	$options['service_section_enable'],
	'sanitize_callback' => 'corpopress_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Corpopress_Pro_Switch_Control( $wp_customize, 'corpopress_pro_theme_options[service_section_enable]', array(
	'label'             => esc_html__( 'Service Section Enable', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_service_section',
	'on_off_label' 		=> corpopress_pro_switch_options(),
) ) );

// service title setting and control
$wp_customize->add_setting( 'corpopress_pro_theme_options[service_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['service_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[service_title]', array(
	'label'           	=> esc_html__( 'Title', 'corpopress-pro' ),
	'section'        	=> 'corpopress_pro_service_section',
	'active_callback' 	=> 'corpopress_pro_is_service_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'corpopress_pro_theme_options[service_title]', array(
		'selector'            => '#services .section-header h2.section-title',
		'settings'            => 'corpopress_pro_theme_options[service_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'corpopress_pro_service_title_partial',
    ) );
}

// service content type control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[service_column]', array(
	'default'          	=> $options['service_column'],
	'sanitize_callback' => 'corpopress_pro_sanitize_select',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[service_column]', array(
	'label'             => esc_html__( 'Column Layout', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_service_section',
	'type'				=> 'select',
	'active_callback' 	=> 'corpopress_pro_is_service_section_enable',
	'choices'			=> array( 
		'col-3'		=> esc_html__( 'Three Column', 'corpopress-pro' ),
		'col-4'		=> esc_html__( 'Four Column', 'corpopress-pro' ),
	),
) );

// Service content type control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[service_content_type]', array(
	'default'          	=> $options['service_content_type'],
	'sanitize_callback' => 'corpopress_pro_sanitize_select',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[service_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_service_section',
	'type'				=> 'select',
	'active_callback' 	=> 'corpopress_pro_is_service_section_enable',
	'choices'			=> array( 
		'page' 		=> esc_html__( 'Page', 'corpopress-pro' ),
		'post' 		=> esc_html__( 'Post', 'corpopress-pro' ),
		'category' 	=> esc_html__( 'Category', 'corpopress-pro' ),
	),
) );

// Event social icons number control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[service_count]', array(
	'default'          	=> $options['service_count'],
	'sanitize_callback' => 'corpopress_pro_sanitize_number_range',
	'validate_callback' => 'corpopress_pro_validate_service_count',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[service_count]', array(
	'label'             => esc_html__( 'Number of Services', 'corpopress-pro' ),
	'description'       => esc_html__( 'Note: Min 2 & Max 12. Please input the valid number and save. Then refresh the page to see the change.', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_service_section',
	'active_callback'   => 'corpopress_pro_is_service_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 2,
		'max'	=> 12,
		'style' => 'width: 100px;'
		),
) );

for ( $i = 1; $i <= $options['service_count']; $i++ ) :

	// service note control and setting
	$wp_customize->add_setting( 'corpopress_pro_theme_options[service_content_icon_' . $i . ']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( new Corpopress_Pro_Icon_Picker( $wp_customize, 'corpopress_pro_theme_options[service_content_icon_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Icon %d', 'corpopress-pro' ), $i ),
		'section'           => 'corpopress_pro_service_section',
		'active_callback'	=> 'corpopress_pro_is_service_section_enable',
	) ) );

	// service pages drop down chooser control and setting
	$wp_customize->add_setting( 'corpopress_pro_theme_options[service_content_page_' . $i . ']', array(
		'sanitize_callback' => 'corpopress_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Corpopress_Pro_Dropdown_Chooser( $wp_customize, 'corpopress_pro_theme_options[service_content_page_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Page %d', 'corpopress-pro' ), $i ),
		'section'           => 'corpopress_pro_service_section',
		'choices'			=> corpopress_pro_page_choices(),
		'active_callback'	=> 'corpopress_pro_is_service_section_content_page_enable',
	) ) );

	// service posts drop down chooser control and setting
	$wp_customize->add_setting( 'corpopress_pro_theme_options[service_content_post_' . $i . ']', array(
		'sanitize_callback' => 'corpopress_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Corpopress_Pro_Dropdown_Chooser( $wp_customize, 'corpopress_pro_theme_options[service_content_post_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Post %d', 'corpopress-pro' ), $i ),
		'section'           => 'corpopress_pro_service_section',
		'choices'			=> corpopress_pro_post_choices(),
		'active_callback'	=> 'corpopress_pro_is_service_section_content_post_enable',
	) ) );

	// service hr setting and control
	$wp_customize->add_setting( 'corpopress_pro_theme_options[service_hr_'. $i .']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new Corpopress_Pro_Customize_Horizontal_Line( $wp_customize, 'corpopress_pro_theme_options[service_hr_'. $i .']',
		array(
			'section'         => 'corpopress_pro_service_section',
			'active_callback' => 'corpopress_pro_is_service_section_content_seperator_enable',
			'type'			  => 'hr'
	) ) );
endfor;

// Add dropdown category setting and control.
$wp_customize->add_setting(  'corpopress_pro_theme_options[service_content_category]', array(
	'sanitize_callback' => 'corpopress_pro_sanitize_single_category',
) ) ;

$wp_customize->add_control( new Corpopress_Pro_Dropdown_Taxonomies_Control( $wp_customize,'corpopress_pro_theme_options[service_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'corpopress-pro' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_service_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'corpopress_pro_is_service_section_content_category_enable'
) ) );
