<?php
/**
 * Slider Section options
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */

// Add Slider section
$wp_customize->add_section( 'corpopress_pro_slider_section', array(
	'title'             => esc_html__( 'Main Slider','corpopress-pro' ),
	'description'       => esc_html__( 'Slider Section options.', 'corpopress-pro' ),
	'panel'             => 'corpopress_pro_front_page_panel',
	'active_callback'   => function( $control ) {
        return ( 
            corpopress_pro_is_default_layout( $control )
            ||
            corpopress_pro_is_second_layout( $control )
            ||
            corpopress_pro_is_fourth_layout( $control )
        );
    },
) );

// Slider content enable control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[slider_section_enable]', array(
	'default'			=> 	$options['slider_section_enable'],
	'sanitize_callback' => 'corpopress_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Corpopress_Pro_Switch_Control( $wp_customize, 'corpopress_pro_theme_options[slider_section_enable]', array(
	'label'             => esc_html__( 'Slider Section Enable', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_slider_section',
	'on_off_label' 		=> corpopress_pro_switch_options(),
) ) );

// Slider btn label setting and control
$wp_customize->add_setting( 'corpopress_pro_theme_options[slider_btn_label]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['slider_btn_label'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[slider_btn_label]', array(
	'label'           	=> esc_html__( 'Slider Button Label', 'corpopress-pro' ),
	'section'        	=> 'corpopress_pro_slider_section',
	'active_callback' 	=> 'corpopress_pro_is_slider_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'corpopress_pro_theme_options[slider_btn_label]', array(
		'selector'            => '.main-slider-wrapper .btn-default',
		'settings'            => 'corpopress_pro_theme_options[slider_btn_label]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'corpopress_pro_slider_btn_label_partial',
    ) );
}

// Slider content enable control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[slider_opacity_enable]', array(
	'default'			=> 	$options['slider_opacity_enable'],
	'sanitize_callback' => 'corpopress_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Corpopress_Pro_Switch_Control( $wp_customize, 'corpopress_pro_theme_options[slider_opacity_enable]', array(
	'label'             => esc_html__( 'Slider Opacity Enable', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_slider_section',
	'on_off_label' 		=> corpopress_pro_switch_options(),
	'active_callback' 	=> 'corpopress_pro_is_slider_section_enable',
) ) );

// Slider content type control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[slider_content_type]', array(
	'default'          	=> $options['slider_content_type'],
	'sanitize_callback' => 'corpopress_pro_sanitize_select',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[slider_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_slider_section',
	'type'				=> 'select',
	'active_callback' 	=> 'corpopress_pro_is_slider_section_enable',
	'choices'			=> array( 
		'page' 		=> esc_html__( 'Page', 'corpopress-pro' ),
		'post' 		=> esc_html__( 'Post', 'corpopress-pro' ),
		'category' 	=> esc_html__( 'Category', 'corpopress-pro' ),
	),
) );

// Event social icons number control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[slider_excerpt]', array(
	'default'          	=> $options['slider_excerpt'],
	'sanitize_callback' => 'corpopress_pro_sanitize_number_range',
	'validate_callback' => 'corpopress_pro_validate_long_excerpt',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[slider_excerpt]', array(
	'label'             => esc_html__( 'Description Length', 'corpopress-pro' ),
	'description'       => esc_html__( 'Note: Min 1 & Max 100. Please input the valid number and save. Then refresh the page to see the change.', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_slider_section',
	'active_callback'   => 'corpopress_pro_is_slider_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'max'	=> 100,
		'style' => 'width: 100px;'
		),
) );

// Event social icons number control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[slider_count]', array(
	'default'          	=> $options['slider_count'],
	'sanitize_callback' => 'corpopress_pro_sanitize_number_range',
	'validate_callback' => 'corpopress_pro_validate_slider_count',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[slider_count]', array(
	'label'             => esc_html__( 'Number of Slides', 'corpopress-pro' ),
	'description'       => esc_html__( 'Note: Min 1 & Max 50. Please input the valid number and save. Then refresh the page to see the change.', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_slider_section',
	'active_callback'   => 'corpopress_pro_is_slider_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'max'	=> 50,
		'style' => 'width: 100px;'
		),
) );

for ( $i = 1; $i <= $options['slider_count']; $i++ ) :
	// slider pages drop down chooser control and setting
	$wp_customize->add_setting( 'corpopress_pro_theme_options[slider_content_page_' . $i . ']', array(
		'sanitize_callback' => 'corpopress_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Corpopress_Pro_Dropdown_Chooser( $wp_customize, 'corpopress_pro_theme_options[slider_content_page_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Page %d', 'corpopress-pro' ), $i ),
		'section'           => 'corpopress_pro_slider_section',
		'choices'			=> corpopress_pro_page_choices(),
		'active_callback'	=> 'corpopress_pro_is_slider_section_content_page_enable',
	) ) );

	// slider posts drop down chooser control and setting
	$wp_customize->add_setting( 'corpopress_pro_theme_options[slider_content_post_' . $i . ']', array(
		'sanitize_callback' => 'corpopress_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Corpopress_Pro_Dropdown_Chooser( $wp_customize, 'corpopress_pro_theme_options[slider_content_post_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Post %d', 'corpopress-pro' ), $i ),
		'section'           => 'corpopress_pro_slider_section',
		'choices'			=> corpopress_pro_post_choices(),
		'active_callback'	=> 'corpopress_pro_is_slider_section_content_post_enable',
	) ) );
endfor;

// Add dropdown category setting and control.
$wp_customize->add_setting(  'corpopress_pro_theme_options[slider_content_category]', array(
	'sanitize_callback' => 'corpopress_pro_sanitize_single_category',
) ) ;

$wp_customize->add_control( new Corpopress_Pro_Dropdown_Taxonomies_Control( $wp_customize,'corpopress_pro_theme_options[slider_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'corpopress-pro' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_slider_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'corpopress_pro_is_slider_section_content_category_enable'
) ) );

// Slider alt btn label setting and control
$wp_customize->add_setting( 'corpopress_pro_theme_options[slider_alt_btn_label]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['slider_alt_btn_label'],
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[slider_alt_btn_label]', array(
	'label'           	=> esc_html__( 'Slider Alt Button Label', 'corpopress-pro' ),
	'section'        	=> 'corpopress_pro_slider_section',
	'active_callback' 	=> 'corpopress_pro_is_slider_section_enable',
	'type'				=> 'text',
) );

// Slider alt btn url setting and control
$wp_customize->add_setting( 'corpopress_pro_theme_options[slider_alt_btn_url]', array(
	'sanitize_callback' => 'esc_url_raw',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[slider_alt_btn_url]', array(
	'label'           	=> esc_html__( 'Slider Alt Button Url', 'corpopress-pro' ),
	'section'        	=> 'corpopress_pro_slider_section',
	'active_callback' 	=> 'corpopress_pro_is_slider_section_enable',
	'type'				=> 'url',
) );