<?php
/**
 * Sponsor Section options
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */

// Add Sponsor section
$wp_customize->add_section( 'corpopress_pro_sponsor_section', array(
	'title'             => esc_html__( 'Sponsor','corpopress-pro' ),
	'description'       => esc_html__( 'Sponsor Section options.', 'corpopress-pro' ),
	'panel'             => 'corpopress_pro_front_page_panel',
	'active_callback'	=>  function( $control ) {
        return ( 
            corpopress_pro_is_second_layout( $control )
        );
    },
) );

// Sponsor content enable control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[sponsor_section_enable]', array(
	'default'			=> 	$options['sponsor_section_enable'],
	'sanitize_callback' => 'corpopress_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Corpopress_Pro_Switch_Control( $wp_customize, 'corpopress_pro_theme_options[sponsor_section_enable]', array(
	'label'             => esc_html__( 'Sponsor Section Enable', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_sponsor_section',
	'on_off_label' 		=> corpopress_pro_switch_options(),
) ) );

// counter image setting and control.
$wp_customize->add_setting( 'corpopress_pro_theme_options[sponsor_bg_image]', array(
	'sanitize_callback' => 'corpopress_pro_sanitize_image'
) );

$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'corpopress_pro_theme_options[sponsor_bg_image]',
		array(
		'label'       		=> esc_html__( 'Sponsor BG Image', 'corpopress-pro' ),
		'section'     		=> 'corpopress_pro_sponsor_section',
		'active_callback'	=> 'corpopress_pro_is_sponsor_section_enable',
) ) );

// long Excerpt length setting and control.
$wp_customize->add_setting( 'corpopress_pro_theme_options[sponsor_excerpt_length]', array(
	'sanitize_callback' => 'corpopress_pro_sanitize_number_range',
	'validate_callback' => 'corpopress_pro_validate_long_excerpt',
	'default'			=> $options['sponsor_excerpt_length'],
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[sponsor_excerpt_length]', array(
	'label'       		=> esc_html__( 'Sponsor Excerpt Length', 'corpopress-pro' ),
	'description' 		=> esc_html__( 'Total description words to be displayed in latest posts.', 'corpopress-pro' ),
	'section'     		=> 'corpopress_pro_sponsor_section',
	'active_callback' 	=> 'corpopress_pro_is_sponsor_section_enable',
	'type'        		=> 'number',
	'input_attrs' 		=> array(
		'style'       => 'width: 80px;',
		'max'         => 100,
		'min'         => 5,
	),
) );

// Sponsor content type control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[sponsor_content_type]', array(
	'default'          	=> $options['sponsor_content_type'],
	'sanitize_callback' => 'corpopress_pro_sanitize_select',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[sponsor_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_sponsor_section',
	'type'				=> 'select',
	'active_callback' 	=> 'corpopress_pro_is_sponsor_section_enable',
	'choices'			=> array( 
		'page' 		=> esc_html__( 'Page', 'corpopress-pro' ),
		'post' 		=> esc_html__( 'Post', 'corpopress-pro' ),
		'custom' 	=> esc_html__( 'Custom', 'corpopress-pro' ),
	),
) );

// sponsor pages drop down chooser control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[sponsor_content_page]', array(
	'sanitize_callback' => 'corpopress_pro_sanitize_page',
) );

$wp_customize->add_control( new Corpopress_Pro_Dropdown_Chooser( $wp_customize, 'corpopress_pro_theme_options[sponsor_content_page]', array(
	'label'             => esc_html__( 'Select Page', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_sponsor_section',
	'choices'			=> corpopress_pro_page_choices(),
	'active_callback'	=> 'corpopress_pro_is_sponsor_section_content_page_enable',
) ) );

// sponsor posts drop down chooser control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[sponsor_content_post]', array(
	'sanitize_callback' => 'corpopress_pro_sanitize_page',
) );

$wp_customize->add_control( new Corpopress_Pro_Dropdown_Chooser( $wp_customize, 'corpopress_pro_theme_options[sponsor_content_post]', array(
	'label'             => esc_html__( 'Select Post', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_sponsor_section',
	'choices'			=> corpopress_pro_post_choices(),
	'active_callback'	=> 'corpopress_pro_is_sponsor_section_content_post_enable',
) ) );

// sponsor title setting and control
$wp_customize->add_setting( 'corpopress_pro_theme_options[sponsor_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['sponsor_title'],
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[sponsor_title]', array(
	'label'           	=> esc_html__( 'Title', 'corpopress-pro' ),
	'section'        	=> 'corpopress_pro_sponsor_section',
	'active_callback' 	=> 'corpopress_pro_is_sponsor_section_content_custom_enable',
	'type'				=> 'text',
) );

// sponsor description setting and control
$wp_customize->add_setting( 'corpopress_pro_theme_options[sponsor_description]', array(
	'sanitize_callback' => 'wp_kses_post',
	'default'			=> $options['sponsor_description'],
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[sponsor_description]', array(
	'label'           	=> esc_html__( 'Description', 'corpopress-pro' ),
	'section'        	=> 'corpopress_pro_sponsor_section',
	'active_callback' 	=> 'corpopress_pro_is_sponsor_section_content_custom_enable',
	'type'				=> 'textarea',
) );

// sponsor btn title setting and control
$wp_customize->add_setting( 'corpopress_pro_theme_options[sponsor_btn_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['sponsor_btn_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[sponsor_btn_title]', array(
	'label'           	=> esc_html__( 'Button Label', 'corpopress-pro' ),
	'section'        	=> 'corpopress_pro_sponsor_section',
	'active_callback' 	=> 'corpopress_pro_is_sponsor_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'corpopress_pro_theme_options[sponsor_btn_title]', array(
		'selector'            => '#sponsor-section .btn',
		'settings'            => 'corpopress_pro_theme_options[sponsor_btn_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'corpopress_pro_sponsor_btn_title_partial',
    ) );
}

// sponsor btn link setting and control
$wp_customize->add_setting( 'corpopress_pro_theme_options[sponsor_btn_link]', array(
	'sanitize_callback' => 'esc_url_raw',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[sponsor_btn_link]', array(
	'label'           	=> esc_html__( 'Button Link', 'corpopress-pro' ),
	'section'        	=> 'corpopress_pro_sponsor_section',
	'active_callback' 	=> 'corpopress_pro_is_sponsor_section_content_custom_enable',
	'type'				=> 'url',
) );