<?php
/**
 * Subscription Section options
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */

// Add Subscription section
$wp_customize->add_section( 'corpopress_pro_subscription_section', array(
	'title'             => esc_html__( 'Subscription','corpopress-pro' ),
	'description'       => esc_html__( 'Note: To activate this section you need to install Jetpack Plugin and activate subscription module.', 'corpopress-pro' ),
	'panel'             => 'corpopress_pro_front_page_panel',
	'active_callback'   => function( $control ) {
        return ( 
            corpopress_pro_is_default_layout( $control )
            ||
            corpopress_pro_is_second_layout( $control )
            ||
            corpopress_pro_is_third_layout( $control )
            ||
            corpopress_pro_is_fourth_layout( $control )
        );
    },
) );

// Subscription content enable control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[subscription_section_enable]', array(
	'default'			=> 	$options['subscription_section_enable'],
	'sanitize_callback' => 'corpopress_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Corpopress_Pro_Switch_Control( $wp_customize, 'corpopress_pro_theme_options[subscription_section_enable]', array(
	'label'             => esc_html__( 'Subscription Section Enable', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_subscription_section',
	'on_off_label' 		=> corpopress_pro_switch_options(),
) ) );

// subscription title setting and control
$wp_customize->add_setting( 'corpopress_pro_theme_options[subscription_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['subscription_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[subscription_title]', array(
	'label'           	=> esc_html__( 'Title', 'corpopress-pro' ),
	'section'        	=> 'corpopress_pro_subscription_section',
	'active_callback' 	=> 'corpopress_pro_is_subscription_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'corpopress_pro_theme_options[subscription_title]', array(
		'selector'            => '#subscribe .section-header h2.section-title',
		'settings'            => 'corpopress_pro_theme_options[subscription_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'corpopress_pro_subscription_title_partial',
    ) );
}

// subscription description setting and control
$wp_customize->add_setting( 'corpopress_pro_theme_options[subscription_subtitle]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['subscription_subtitle'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[subscription_subtitle]', array(
	'label'           	=> esc_html__( 'Sub Title', 'corpopress-pro' ),
	'section'        	=> 'corpopress_pro_subscription_section',
	'active_callback' 	=> 'corpopress_pro_is_subscription_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'corpopress_pro_theme_options[subscription_subtitle]', array(
		'selector'            => '#subscribe .section-header p',
		'settings'            => 'corpopress_pro_theme_options[subscription_subtitle]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'corpopress_pro_subscription_subtitle_partial',
    ) );
}

// subscription image setting and control.
$wp_customize->add_setting( 'corpopress_pro_theme_options[subscription_image]', array(
	'sanitize_callback' => 'corpopress_pro_sanitize_image',
	'default'			=> $options['subscription_image'],
) );

$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'corpopress_pro_theme_options[subscription_image]',
		array(
		'label'       		=> esc_html__( 'Image', 'corpopress-pro' ),
		'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'corpopress-pro' ), 1280, 854 ),
		'section'     		=> 'corpopress_pro_subscription_section',
		'active_callback'	=> 'corpopress_pro_is_subscription_section_enable',
) ) );

// subscription btn title setting and control
$wp_customize->add_setting( 'corpopress_pro_theme_options[subscription_btn_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['subscription_btn_title'],
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[subscription_btn_title]', array(
	'label'           	=> esc_html__( 'Button Label', 'corpopress-pro' ),
	'section'        	=> 'corpopress_pro_subscription_section',
	'active_callback' 	=> 'corpopress_pro_is_subscription_section_enable',
	'type'				=> 'text',
) );

