<?php
/**
 * Team Section options
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */

// Add Team section
$wp_customize->add_section( 'corpopress_pro_team_section', array(
	'title'             => esc_html__( 'Team','corpopress-pro' ),
	'description'       => esc_html__( 'Team Section options.', 'corpopress-pro' ),
	'panel'             => 'corpopress_pro_front_page_panel',
	'active_callback'   => function( $control ) {
        return ( 
            corpopress_pro_is_default_layout( $control )
        );
    },
) );

// Team content enable control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[team_section_enable]', array(
	'default'			=> 	$options['team_section_enable'],
	'sanitize_callback' => 'corpopress_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Corpopress_Pro_Switch_Control( $wp_customize, 'corpopress_pro_theme_options[team_section_enable]', array(
	'label'             => esc_html__( 'Team Section Enable', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_team_section',
	'on_off_label' 		=> corpopress_pro_switch_options(),
) ) );

// team title setting and control
$wp_customize->add_setting( 'corpopress_pro_theme_options[team_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['team_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[team_title]', array(
	'label'           	=> esc_html__( 'Title', 'corpopress-pro' ),
	'section'        	=> 'corpopress_pro_team_section',
	'active_callback' 	=> 'corpopress_pro_is_team_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'corpopress_pro_theme_options[team_title]', array(
		'selector'            => '#team .section-header h2.section-title',
		'settings'            => 'corpopress_pro_theme_options[team_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'corpopress_pro_team_title_partial',
    ) );
}

// team btn title setting and control
$wp_customize->add_setting( 'corpopress_pro_theme_options[team_btn_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['team_btn_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[team_btn_title]', array(
	'label'           	=> esc_html__( 'Button Title', 'corpopress-pro' ),
	'section'        	=> 'corpopress_pro_team_section',
	'active_callback' 	=> 'corpopress_pro_is_team_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'corpopress_pro_theme_options[team_btn_title]', array(
		'selector'            => '#team .team-wrapper a.btn',
		'settings'            => 'corpopress_pro_theme_options[team_btn_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'corpopress_pro_team_btn_title_partial',
    ) );
}

// team btn url setting and control
$wp_customize->add_setting( 'corpopress_pro_theme_options[team_btn_url]', array(
	'sanitize_callback' => 'esc_url_raw',
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[team_btn_url]', array(
	'label'           	=> esc_html__( 'Button Url', 'corpopress-pro' ),
	'section'        	=> 'corpopress_pro_team_section',
	'active_callback' 	=> 'corpopress_pro_is_team_section_enable',
	'type'				=> 'url',
) );

// Team content type control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[team_content_type]', array(
	'default'          	=> $options['team_content_type'],
	'sanitize_callback' => 'corpopress_pro_sanitize_select',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[team_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_team_section',
	'type'				=> 'select',
	'active_callback' 	=> 'corpopress_pro_is_team_section_enable',
	'choices'			=> array( 
		'page' 		=> esc_html__( 'Page', 'corpopress-pro' ),
		'post' 		=> esc_html__( 'Post', 'corpopress-pro' ),
		'category' 	=> esc_html__( 'Category', 'corpopress-pro' ),
		'custom' 	=> esc_html__( 'Custom', 'corpopress-pro' ),
	),
) );

// Add dropdown category setting and control.
$wp_customize->add_setting(  'corpopress_pro_theme_options[team_content_category]', array(
	'sanitize_callback' => 'corpopress_pro_sanitize_single_category',
) ) ;

$wp_customize->add_control( new Corpopress_Pro_Dropdown_Taxonomies_Control( $wp_customize,'corpopress_pro_theme_options[team_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'corpopress-pro' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_team_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'corpopress_pro_is_team_section_content_category_enable'
) ) );

for ( $i = 1; $i <= 4; $i++ ) :
	// team pages drop down chooser control and setting
	$wp_customize->add_setting( 'corpopress_pro_theme_options[team_content_page_' . $i . ']', array(
		'sanitize_callback' => 'corpopress_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Corpopress_Pro_Dropdown_Chooser( $wp_customize, 'corpopress_pro_theme_options[team_content_page_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Page %d', 'corpopress-pro' ), $i ),
		'section'           => 'corpopress_pro_team_section',
		'choices'			=> corpopress_pro_page_choices(),
		'active_callback'	=> 'corpopress_pro_is_team_section_content_page_enable',
	) ) );

	// team posts drop down chooser control and setting
	$wp_customize->add_setting( 'corpopress_pro_theme_options[team_content_post_' . $i . ']', array(
		'sanitize_callback' => 'corpopress_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Corpopress_Pro_Dropdown_Chooser( $wp_customize, 'corpopress_pro_theme_options[team_content_post_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Post %d', 'corpopress-pro' ), $i ),
		'section'           => 'corpopress_pro_team_section',
		'choices'			=> corpopress_pro_post_choices(),
		'active_callback'	=> 'corpopress_pro_is_team_section_content_post_enable',
	) ) );

	// team title setting and control
	$wp_customize->add_setting( 'corpopress_pro_theme_options[team_title_' . $i . ']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'corpopress_pro_theme_options[team_title_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Title %d', 'corpopress-pro' ), $i ),
		'section'        	=> 'corpopress_pro_team_section',
		'active_callback' 	=> 'corpopress_pro_is_team_section_content_custom_enable',
		'type'				=> 'text',
	) );

	// team position setting and control
	$wp_customize->add_setting( 'corpopress_pro_theme_options[team_position_' . $i . ']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'corpopress_pro_theme_options[team_position_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Position %d', 'corpopress-pro' ), $i ),
		'section'        	=> 'corpopress_pro_team_section',
		'active_callback' 	=> 'corpopress_pro_is_team_section_content_position_enable',
		'type'				=> 'text',
	) );

	// team image setting and control.
	$wp_customize->add_setting( 'corpopress_pro_theme_options[team_image_' . $i . ']', array(
		'sanitize_callback' => 'corpopress_pro_sanitize_image'
	) );

	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'corpopress_pro_theme_options[team_image_' . $i . ']',
			array(
			'label'       		=> sprintf( esc_html__( 'Image %d', 'corpopress-pro' ), $i ),
			'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'corpopress-pro' ), 382, 420 ),
			'section'     		=> 'corpopress_pro_team_section',
			'active_callback'	=> 'corpopress_pro_is_team_section_content_custom_enable',
	) ) );

	// team position setting and control
	$wp_customize->add_setting( 'corpopress_pro_theme_options[team_link_' . $i . ']', array(
		'sanitize_callback' => 'esc_url_raw',
	) );

	$wp_customize->add_control( 'corpopress_pro_theme_options[team_link_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'URL Link %d', 'corpopress-pro' ), $i ),
		'section'        	=> 'corpopress_pro_team_section',
		'active_callback' 	=> 'corpopress_pro_is_team_section_content_custom_enable',
		'type'				=> 'url',
	) );

	// team multiple input setting and control
	$wp_customize->add_setting( 'corpopress_pro_theme_options[team_social_'. $i .']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new Corpopress_Pro_Multi_Input_Custom_Control( $wp_customize, 'corpopress_pro_theme_options[team_social_'. $i .']',
		array(
			'label'           => sprintf( esc_html__( 'Social Link %d', 'corpopress-pro' ), $i ),
			'button_text'	  => esc_html__( 'Add Social Link', 'corpopress-pro' ),
			'section'         => 'corpopress_pro_team_section',
			'active_callback' => 'corpopress_pro_is_team_section_content_position_enable',
			'type'			  => 'multi-input'
	) ) );

	// team hr setting and control
	$wp_customize->add_setting( 'corpopress_pro_theme_options[team_hr_'. $i .']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new Corpopress_Pro_Customize_Horizontal_Line( $wp_customize, 'corpopress_pro_theme_options[team_hr_'. $i .']',
		array(
			'section'         => 'corpopress_pro_team_section',
			'active_callback' => 'corpopress_pro_is_team_section_content_seperator_enable',
			'type'			  => 'hr'
	) ) );
endfor;

