<?php
/**
 * Testimonial Section options
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */

// Add Testimonial section
$wp_customize->add_section( 'corpopress_pro_testimonial_section', array(
	'title'             => esc_html__( 'Testimonial','corpopress-pro' ),
	'description'       => esc_html__( 'Testimonial Section options.', 'corpopress-pro' ),
	'panel'             => 'corpopress_pro_front_page_panel',
	'active_callback'   => function( $control ) {
        return ( 
            corpopress_pro_is_default_layout( $control )
        );
    },
) );

// Testimonial content enable control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[testimonial_section_enable]', array(
	'default'			=> 	$options['testimonial_section_enable'],
	'sanitize_callback' => 'corpopress_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Corpopress_Pro_Switch_Control( $wp_customize, 'corpopress_pro_theme_options[testimonial_section_enable]', array(
	'label'             => esc_html__( 'Testimonial Section Enable', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_testimonial_section',
	'on_off_label' 		=> corpopress_pro_switch_options(),
) ) );

// testimonial title setting and control
$wp_customize->add_setting( 'corpopress_pro_theme_options[testimonial_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['testimonial_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[testimonial_title]', array(
	'label'           	=> esc_html__( 'Title', 'corpopress-pro' ),
	'section'        	=> 'corpopress_pro_testimonial_section',
	'active_callback' 	=> 'corpopress_pro_is_testimonial_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'corpopress_pro_theme_options[testimonial_title]', array(
		'selector'            => '#testimonial .section-header h2.section-title',
		'settings'            => 'corpopress_pro_theme_options[testimonial_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'corpopress_pro_testimonial_title_partial',
    ) );
}

// Testimonial content type control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[testimonial_column]', array(
	'default'          	=> $options['testimonial_column'],
	'sanitize_callback' => 'corpopress_pro_sanitize_select',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[testimonial_column]', array(
	'label'             => esc_html__( 'Column Layout', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_testimonial_section',
	'type'				=> 'select',
	'active_callback' 	=> 'corpopress_pro_is_testimonial_section_enable',
	'choices'			=> array( 
		'col-2' 		=> esc_html__( 'Two Column', 'corpopress-pro' ),
		'col-3' 		=> esc_html__( 'Three Column', 'corpopress-pro' ),
		'col-4' 		=> esc_html__( 'Four Column', 'corpopress-pro' ),
	),
) );

// Testimonial content type control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[testimonial_content_type]', array(
	'default'          	=> $options['testimonial_content_type'],
	'sanitize_callback' => 'corpopress_pro_sanitize_select',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[testimonial_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_testimonial_section',
	'type'				=> 'select',
	'active_callback' 	=> 'corpopress_pro_is_testimonial_section_enable',
	'choices'			=> array( 
		'page' 		=> esc_html__( 'Page', 'corpopress-pro' ),
		'post' 		=> esc_html__( 'Post', 'corpopress-pro' ),
		'category' 	=> esc_html__( 'Category', 'corpopress-pro' ),
		'custom' 	=> esc_html__( 'Custom', 'corpopress-pro' ),
	),
) );

// Event social icons number control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[testimonial_count]', array(
	'default'          	=> $options['testimonial_count'],
	'sanitize_callback' => 'corpopress_pro_sanitize_number_range',
	'validate_callback' => 'corpopress_pro_validate_testimonial_count',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[testimonial_count]', array(
	'label'             => esc_html__( 'Number of Testimonials', 'corpopress-pro' ),
	'description'       => esc_html__( 'Note: Min 1 & Max 10. Please input the valid number and save. Then refresh the page to see the change.', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_testimonial_section',
	'active_callback'   => 'corpopress_pro_is_testimonial_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'max'	=> 10,
		'style' => 'width: 100px;'
		),
) );

// Add dropdown category setting and control.
$wp_customize->add_setting(  'corpopress_pro_theme_options[testimonial_content_category]', array(
	'sanitize_callback' => 'corpopress_pro_sanitize_single_category',
) ) ;

$wp_customize->add_control( new Corpopress_Pro_Dropdown_Taxonomies_Control( $wp_customize,'corpopress_pro_theme_options[testimonial_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'corpopress-pro' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_testimonial_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'corpopress_pro_is_testimonial_section_content_category_enable'
) ) );

for ( $i = 1; $i <= $options['testimonial_count']; $i++ ) :
	// testimonial pages drop down chooser control and setting
	$wp_customize->add_setting( 'corpopress_pro_theme_options[testimonial_content_page_' . $i . ']', array(
		'sanitize_callback' => 'corpopress_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Corpopress_Pro_Dropdown_Chooser( $wp_customize, 'corpopress_pro_theme_options[testimonial_content_page_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Page %d', 'corpopress-pro' ), $i ),
		'section'           => 'corpopress_pro_testimonial_section',
		'choices'			=> corpopress_pro_page_choices(),
		'active_callback'	=> 'corpopress_pro_is_testimonial_section_content_page_enable',
	) ) );

	// testimonial posts drop down chooser control and setting
	$wp_customize->add_setting( 'corpopress_pro_theme_options[testimonial_content_post_' . $i . ']', array(
		'sanitize_callback' => 'corpopress_pro_sanitize_page',
	) );

	$wp_customize->add_control( new Corpopress_Pro_Dropdown_Chooser( $wp_customize, 'corpopress_pro_theme_options[testimonial_content_post_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Post %d', 'corpopress-pro' ), $i ),
		'section'           => 'corpopress_pro_testimonial_section',
		'choices'			=> corpopress_pro_post_choices(),
		'active_callback'	=> 'corpopress_pro_is_testimonial_section_content_post_enable',
	) ) );

	// testimonial title setting and control
	$wp_customize->add_setting( 'corpopress_pro_theme_options[testimonial_title_' . $i . ']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'corpopress_pro_theme_options[testimonial_title_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Title %d', 'corpopress-pro' ), $i ),
		'section'        	=> 'corpopress_pro_testimonial_section',
		'active_callback' 	=> 'corpopress_pro_is_testimonial_section_content_custom_enable',
		'type'				=> 'text',
	) );

	// testimonial position setting and control
	$wp_customize->add_setting( 'corpopress_pro_theme_options[testimonial_position_' . $i . ']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'corpopress_pro_theme_options[testimonial_position_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Position %d', 'corpopress-pro' ), $i ),
		'section'        	=> 'corpopress_pro_testimonial_section',
		'active_callback' 	=> 'corpopress_pro_is_testimonial_section_content_position_enable',
		'type'				=> 'text',
	) );

	// testimonial description setting and control
	$wp_customize->add_setting( 'corpopress_pro_theme_options[testimonial_description_' . $i . ']', array(
		'sanitize_callback' => 'wp_kses_post',
	) );

	$wp_customize->add_control( 'corpopress_pro_theme_options[testimonial_description_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Description %d', 'corpopress-pro' ), $i ),
		'section'        	=> 'corpopress_pro_testimonial_section',
		'active_callback' 	=> 'corpopress_pro_is_testimonial_section_content_custom_enable',
		'type'				=> 'textarea',
	) );

	// testimonial image setting and control.
	$wp_customize->add_setting( 'corpopress_pro_theme_options[testimonial_image_' . $i . ']', array(
		'sanitize_callback' => 'corpopress_pro_sanitize_image'
	) );

	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'corpopress_pro_theme_options[testimonial_image_' . $i . ']',
			array(
			'label'       		=> sprintf( esc_html__( 'Image %d', 'corpopress-pro' ), $i ),
			'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'corpopress-pro' ), 200, 200 ),
			'section'     		=> 'corpopress_pro_testimonial_section',
			'active_callback'	=> 'corpopress_pro_is_testimonial_section_content_custom_enable',
	) ) );

	// testimonial position setting and control
	$wp_customize->add_setting( 'corpopress_pro_theme_options[testimonial_link_' . $i . ']', array(
		'sanitize_callback' => 'esc_url_raw',
	) );

	$wp_customize->add_control( 'corpopress_pro_theme_options[testimonial_link_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'URL Link %d', 'corpopress-pro' ), $i ),
		'section'        	=> 'corpopress_pro_testimonial_section',
		'active_callback' 	=> 'corpopress_pro_is_testimonial_section_content_custom_enable',
		'type'				=> 'url',
	) );

	// testimonial hr setting and control
	$wp_customize->add_setting( 'corpopress_pro_theme_options[testimonial_hr_'. $i .']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new Corpopress_Pro_Customize_Horizontal_Line( $wp_customize, 'corpopress_pro_theme_options[testimonial_hr_'. $i .']',
		array(
			'section'         => 'corpopress_pro_testimonial_section',
			'active_callback' => 'corpopress_pro_is_testimonial_section_content_seperator_enable',
			'type'			  => 'hr'
	) ) );
endfor;

