<?php
/**
 * Topbar Section options
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */

// Add Topbar section
$wp_customize->add_section( 'corpopress_pro_topbar_section', array(
	'title'             => esc_html__( 'Header Meta','corpopress-pro' ),
	'description'       => esc_html__( 'Header Meta options.', 'corpopress-pro' ),
	'panel'             => 'corpopress_pro_front_page_panel',
) );

if( in_array($options['home_layout'], array( 'third-design', 'fourth-design' )) ){

// top bar menu visible
$wp_customize->add_setting( 'corpopress_pro_theme_options[topbar_enable]',
	array(
		'default'       	=> $options['topbar_enable'],
		'sanitize_callback' => 'corpopress_pro_sanitize_switch_control',

	)
);
$wp_customize->add_control( new Corpopress_Pro_Switch_Control( $wp_customize, 'corpopress_pro_theme_options[topbar_enable]',
    array(
		'label'      		=> esc_html__( 'Topbar Enable', 'corpopress-pro' ),
		'section'    		=> 'corpopress_pro_topbar_section',
		'on_off_label' 		=> corpopress_pro_switch_options(),
    )
) );

}

// top bar menu visible
$wp_customize->add_setting( 'corpopress_pro_theme_options[topbar_social_enable]',
	array(
		'default'       	=> $options['topbar_social_enable'],
		'sanitize_callback' => 'corpopress_pro_sanitize_switch_control',
	)
);
$wp_customize->add_control( new Corpopress_Pro_Switch_Control( $wp_customize, 'corpopress_pro_theme_options[topbar_social_enable]',
    array(
		'label'      		=> esc_html__( 'Display Social Menu', 'corpopress-pro' ),
		'description'       => sprintf( '%1$s <a class="topbar-menu-trigger" href="#"> %2$s </a> %3$s', esc_html__( 'Note: To show topbar menu.', 'corpopress-pro' ), esc_html__( 'Click Here', 'corpopress-pro' ), esc_html__( 'to create menu', 'corpopress-pro' ) ),
		'section'    		=> 'corpopress_pro_topbar_section',
		'on_off_label' 		=> corpopress_pro_switch_options(),
    )
) );

// topbar phone setting and control
$wp_customize->add_setting( 'corpopress_pro_theme_options[topbar_phone]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['topbar_phone'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[topbar_phone]', array(
	'label'           	=> esc_html__( 'Phone No.', 'corpopress-pro' ),
	'section'        	=> 'corpopress_pro_topbar_section',
	'type'				=> 'text',

) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'corpopress_pro_theme_options[topbar_phone]', array(
		'selector'            => '#masthead .site-branding span.phone a',
		'settings'            => 'corpopress_pro_theme_options[topbar_phone]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'corpopress_pro_topbar_phone_partial',
    ) );
}

if( in_array($options['home_layout'], array( 'third-design', 'fourth-design' )) ){

// topbar phone setting and control
$wp_customize->add_setting( 'corpopress_pro_theme_options[topbar_email]', array(
	'sanitize_callback' => 'sanitize_email',
	'default'			=> $options['topbar_email'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[topbar_email]', array(
	'label'           	=> esc_html__( 'Email ID', 'corpopress-pro' ),
	'section'        	=> 'corpopress_pro_topbar_section',
	'type'				=> 'email',
	'active_callback'	=> 'corpopress_pro_is_topbar_section_enable',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'corpopress_pro_theme_options[topbar_email]', array(
		'selector'            => '#top-bar .mail',
		'settings'            => 'corpopress_pro_theme_options[topbar_email]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'corpopress_pro_topbar_email_partial',
    ) );
}

// topbar phone setting and control
$wp_customize->add_setting( 'corpopress_pro_theme_options[topbar_location]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['topbar_location'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[topbar_location]', array(
	'label'           	=> esc_html__( 'Location / Address', 'corpopress-pro' ),
	'section'        	=> 'corpopress_pro_topbar_section',
	'type'				=> 'text',
	'active_callback'	=> 'corpopress_pro_is_topbar_section_enable',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'corpopress_pro_theme_options[topbar_location]', array(
		'selector'            => '#top-bar .address',
		'settings'            => 'corpopress_pro_theme_options[topbar_location]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'corpopress_pro_topbar_location_partial',
    ) );
}

}

if( $options['home_layout'] == 'third-design'){

// contact image setting and control.
$wp_customize->add_setting( 'corpopress_pro_theme_options[topbar_ads_image]', array(
	'sanitize_callback' => 'corpopress_pro_sanitize_image'
) );

$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'corpopress_pro_theme_options[topbar_ads_image]',
		array(
		'label'       		=> esc_html__( 'Advertisement Here', 'corpopress-pro' ),
		'section'     		=> 'corpopress_pro_topbar_section',
) ) );

// contact btn link setting and control
$wp_customize->add_setting( 'corpopress_pro_theme_options[topbar_ads_url]', array(
	'sanitize_callback' => 'esc_url_raw',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[topbar_ads_url]', array(
	'label'           	=> esc_html__( 'Advertisement Link', 'corpopress-pro' ),
	'section'        	=> 'corpopress_pro_topbar_section',
	'type'				=> 'url',
) );

}