<?php
/**
 * Archive options
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */

// Add archive section
$wp_customize->add_section( 'corpopress_pro_archive_section', array(
	'title'             => esc_html__( 'Blog/Archive','corpopress-pro' ),
	'description'       => esc_html__( 'Archive section options.', 'corpopress-pro' ),
	'panel'             => 'corpopress_pro_theme_options_panel',
) );

// Your latest posts title setting and control.
$wp_customize->add_setting( 'corpopress_pro_theme_options[your_latest_posts_title]', array(
	'default'           => $options['your_latest_posts_title'],
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[your_latest_posts_title]', array(
	'label'             => esc_html__( 'Your Latest Posts Title', 'corpopress-pro' ),
	'description'       => esc_html__( 'This option only works if Static Front Page is set to "Your latest posts."', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_archive_section',
	'type'				=> 'text',
	'active_callback'   => 'corpopress_pro_is_latest_posts'
) );

// Archive date meta setting and control.
$wp_customize->add_setting( 'corpopress_pro_theme_options[hide_date]', array(
	'default'           => $options['hide_date'],
	'sanitize_callback' => 'corpopress_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Corpopress_Pro_Switch_Control( $wp_customize, 'corpopress_pro_theme_options[hide_date]', array(
	'label'             => esc_html__( 'Hide Date', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_archive_section',
	'on_off_label' 		=> corpopress_pro_hide_options(),
) ) );

// Archive author category setting and control.
$wp_customize->add_setting( 'corpopress_pro_theme_options[hide_author]', array(
	'default'           => $options['hide_author'],
	'sanitize_callback' => 'corpopress_pro_sanitize_switch_control',
) );

$wp_customize->add_control( new Corpopress_Pro_Switch_Control( $wp_customize, 'corpopress_pro_theme_options[hide_author]', array(
	'label'             => esc_html__( 'Hide Author', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_archive_section',
	'on_off_label' 		=> corpopress_pro_hide_options(),
) ) );

// Blog content type control and setting
$wp_customize->add_setting( 'corpopress_pro_theme_options[archive_column]', array(
	'default'          	=> $options['archive_column'],
	'sanitize_callback' => 'corpopress_pro_sanitize_select',
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[archive_column]', array(
	'label'             => esc_html__( 'Column Layout', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_archive_section',
	'type'				=> 'select',
	'choices'			=> array( 
		'col-2' 	=> esc_html__( 'Two Column', 'corpopress-pro' ),
		'col-3' 	=> esc_html__( 'Three Column', 'corpopress-pro' ),
	),
) );