<?php
/**
 * Breadcrumb options
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */

$wp_customize->add_section( 'corpopress_pro_breadcrumb', array(
	'title'             => esc_html__( 'Breadcrumb','corpopress-pro' ),
	'description'       => esc_html__( 'Breadcrumb section options.', 'corpopress-pro' ),
	'panel'             => 'corpopress_pro_theme_options_panel',
) );

// Breadcrumb enable setting and control.
$wp_customize->add_setting( 'corpopress_pro_theme_options[breadcrumb_enable]', array(
	'sanitize_callback' => 'corpopress_pro_sanitize_switch_control',
	'default'          	=> $options['breadcrumb_enable'],
) );

$wp_customize->add_control( new Corpopress_Pro_Switch_Control( $wp_customize, 'corpopress_pro_theme_options[breadcrumb_enable]', array(
	'label'            	=> esc_html__( 'Enable Breadcrumb', 'corpopress-pro' ),
	'section'          	=> 'corpopress_pro_breadcrumb',
	'on_off_label' 		=> corpopress_pro_switch_options(),
) ) );

// Breadcrumb separator setting and control.
$wp_customize->add_setting( 'corpopress_pro_theme_options[breadcrumb_separator]', array(
	'sanitize_callback'	=> 'sanitize_text_field',
	'default'          	=> $options['breadcrumb_separator'],
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[breadcrumb_separator]', array(
	'label'            	=> esc_html__( 'Separator', 'corpopress-pro' ),
	'active_callback' 	=> 'corpopress_pro_is_breadcrumb_enable',
	'section'          	=> 'corpopress_pro_breadcrumb',
) );
