<?php
/**
 * Footer options
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */

// Footer Section
$wp_customize->add_section( 'corpopress_pro_section_footer',
	array(
		'title'      			=> esc_html__( 'Footer Options', 'corpopress-pro' ),
		'priority'   			=> 900,
		'panel'      			=> 'corpopress_pro_theme_options_panel',
	)
);

// footer text
$wp_customize->add_setting( 'corpopress_pro_theme_options[copyright_text]',
	array(
		'default'       		=> $options['copyright_text'],
		'sanitize_callback'		=> 'corpopress_pro_santize_allow_tag',
		'transport'				=> 'postMessage',
	)
);
$wp_customize->add_control( 'corpopress_pro_theme_options[copyright_text]',
    array(
		'label'      			=> esc_html__( 'Copyright Text', 'corpopress-pro' ),
		'section'    			=> 'corpopress_pro_section_footer',
		'type'		 			=> 'textarea',
    )
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'corpopress_pro_theme_options[copyright_text]', array(
		'selector'            => '.site-info .copyright span',
		'settings'            => 'corpopress_pro_theme_options[copyright_text]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'corpopress_pro_copyright_text_partial',
    ) );
}

// scroll top visible
$wp_customize->add_setting( 'corpopress_pro_theme_options[scroll_top_visible]',
	array(
		'default'       	=> $options['scroll_top_visible'],
		'sanitize_callback' => 'corpopress_pro_sanitize_switch_control',
	)
);
$wp_customize->add_control( new Corpopress_Pro_Switch_Control( $wp_customize, 'corpopress_pro_theme_options[scroll_top_visible]',
    array(
		'label'      		=> esc_html__( 'Display Scroll Top Button', 'corpopress-pro' ),
		'section'    		=> 'corpopress_pro_section_footer',
		'on_off_label' 		=> corpopress_pro_switch_options(),
    )
) );