<?php
/**
 * Layout options
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */

// Add sidebar section
$wp_customize->add_section( 'corpopress_pro_layout', array(
	'title'               => esc_html__('Layout','corpopress-pro'),
	'description'         => esc_html__( 'Layout section options.', 'corpopress-pro' ),
	'panel'               => 'corpopress_pro_theme_options_panel',
) );

// Site layout setting and control.
$wp_customize->add_setting( 'corpopress_pro_theme_options[site_layout]', array(
	'sanitize_callback'   => 'corpopress_pro_sanitize_select',
	'default'             => $options['site_layout'],
) );

$wp_customize->add_control(  new Corpopress_Pro_Custom_Radio_Image_Control ( $wp_customize, 'corpopress_pro_theme_options[site_layout]', array(
	'label'               => esc_html__( 'Site Layout', 'corpopress-pro' ),
	'section'             => 'corpopress_pro_layout',
	'choices'			  => corpopress_pro_site_layout(),
) ) );

// Sidebar position setting and control.
$wp_customize->add_setting( 'corpopress_pro_theme_options[sidebar_position]', array(
	'sanitize_callback'   => 'corpopress_pro_sanitize_select',
	'default'             => $options['sidebar_position'],
) );

$wp_customize->add_control(  new Corpopress_Pro_Custom_Radio_Image_Control ( $wp_customize, 'corpopress_pro_theme_options[sidebar_position]', array(
	'label'               => esc_html__( 'Global Sidebar Position', 'corpopress-pro' ),
	'section'             => 'corpopress_pro_layout',
	'choices'			  => corpopress_pro_global_sidebar_position(),
) ) );

// Post sidebar position setting and control.
$wp_customize->add_setting( 'corpopress_pro_theme_options[post_sidebar_position]', array(
	'sanitize_callback'   => 'corpopress_pro_sanitize_select',
	'default'             => $options['post_sidebar_position'],
) );

$wp_customize->add_control(  new Corpopress_Pro_Custom_Radio_Image_Control ( $wp_customize, 'corpopress_pro_theme_options[post_sidebar_position]', array(
	'label'               => esc_html__( 'Posts Sidebar Position', 'corpopress-pro' ),
	'section'             => 'corpopress_pro_layout',
	'choices'			  => corpopress_pro_sidebar_position(),
) ) );

// Post sidebar position setting and control.
$wp_customize->add_setting( 'corpopress_pro_theme_options[page_sidebar_position]', array(
	'sanitize_callback'   => 'corpopress_pro_sanitize_select',
	'default'             => $options['page_sidebar_position'],
) );

$wp_customize->add_control( new Corpopress_Pro_Custom_Radio_Image_Control( $wp_customize, 'corpopress_pro_theme_options[page_sidebar_position]', array(
	'label'               => esc_html__( 'Pages Sidebar Position', 'corpopress-pro' ),
	'section'             => 'corpopress_pro_layout',
	'choices'			  => corpopress_pro_sidebar_position(),
) ) );