<?php
/**
 * Loader options
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */

$wp_customize->add_section( 'corpopress_pro_loader', array(
	'title'            		=> esc_html__( 'Loader','corpopress-pro' ),
	'description'      		=> esc_html__( 'Loader section options.', 'corpopress-pro' ),
	'panel'            		=> 'corpopress_pro_theme_options_panel',
) );

// Loader enable setting and control.
$wp_customize->add_setting( 'corpopress_pro_theme_options[loader_enable]', array(
	'sanitize_callback' => 'corpopress_pro_sanitize_switch_control',
	'default'             	=> $options['loader_enable'],
) );

$wp_customize->add_control(  new Corpopress_Pro_Switch_Control( $wp_customize, 'corpopress_pro_theme_options[loader_enable]', array(
	'label'               	=> esc_html__( 'Enable loader', 'corpopress-pro' ),
	'section'             	=> 'corpopress_pro_loader',
	'on_off_label' 		=> corpopress_pro_switch_options(),
) ) );

// Loader icons setting and control.
$wp_customize->add_setting( 'corpopress_pro_theme_options[loader_icon]', array(
	'sanitize_callback' 	=> 'corpopress_pro_sanitize_select',
	'default'				=> $options['loader_icon'],
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[loader_icon]', array(
	'label'           		=> esc_html__( 'Icon', 'corpopress-pro' ),
	'section'         		=> 'corpopress_pro_loader',
	'type'					=> 'select',
	'choices'				=> corpopress_pro_get_spinner_list(),
	'active_callback' 		=> 'corpopress_pro_is_loader_enable',
) );
