<?php
/**
 * Menu options
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */

// Add sidebar section
$wp_customize->add_section( 'corpopress_pro_menu', array(
	'title'             => esc_html__('Header Menu','corpopress-pro'),
	'description'       => esc_html__( 'Header Menu options.', 'corpopress-pro' ),
	'panel'             => 'nav_menus',
) );

// Menu sticky setting and control.
$wp_customize->add_setting( 'corpopress_pro_theme_options[menu_sticky]', array(
	'sanitize_callback' => 'corpopress_pro_sanitize_switch_control',
	'default'           => $options['menu_sticky'],
) );

$wp_customize->add_control( new Corpopress_Pro_Switch_Control( $wp_customize, 'corpopress_pro_theme_options[menu_sticky]', array(
	'label'             => esc_html__( 'Make Menu Sticky', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_menu',
	'on_off_label' 		=> corpopress_pro_switch_options(),
) ) );

// search enable setting and control.
$wp_customize->add_setting( 'corpopress_pro_theme_options[nav_search_enable]', array(
	'sanitize_callback' => 'corpopress_pro_sanitize_switch_control',
	'default'           => $options['nav_search_enable'],
) );

$wp_customize->add_control( new Corpopress_Pro_Switch_Control( $wp_customize, 'corpopress_pro_theme_options[nav_search_enable]', array(
	'label'             => esc_html__( 'Enable search', 'corpopress-pro' ),
	'section'           => 'corpopress_pro_menu',
	'on_off_label' 		=> corpopress_pro_switch_options(),
) ) );