<?php
/**
 * pagination options
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */

// Add sidebar section
$wp_customize->add_section( 'corpopress_pro_pagination', array(
	'title'               => esc_html__('Pagination','corpopress-pro'),
	'description'         => esc_html__( 'Pagination section options.', 'corpopress-pro' ),
	'panel'               => 'corpopress_pro_theme_options_panel',
) );

// Sidebar position setting and control.
$wp_customize->add_setting( 'corpopress_pro_theme_options[pagination_enable]', array(
	'sanitize_callback' => 'corpopress_pro_sanitize_switch_control',
	'default'             => $options['pagination_enable'],
) );

$wp_customize->add_control( new Corpopress_Pro_Switch_Control( $wp_customize, 'corpopress_pro_theme_options[pagination_enable]', array(
	'label'               => esc_html__( 'Pagination Enable', 'corpopress-pro' ),
	'section'             => 'corpopress_pro_pagination',
	'on_off_label' 		=> corpopress_pro_switch_options(),
) ) );

// Site layout setting and control.
$wp_customize->add_setting( 'corpopress_pro_theme_options[pagination_type]', array(
	'sanitize_callback'   => 'corpopress_pro_sanitize_select',
	'default'             => $options['pagination_type'],
) );

$wp_customize->add_control( 'corpopress_pro_theme_options[pagination_type]', array(
	'label'               => esc_html__( 'Pagination Type', 'corpopress-pro' ),
	'section'             => 'corpopress_pro_pagination',
	'type'                => 'select',
	'choices'			  => corpopress_pro_pagination_options(),
	'active_callback'	  => 'corpopress_pro_is_pagination_enable',
) );
