<?php
/**
 * Section Sortable options
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */

// Add sidebar section
$wp_customize->add_section( 'corpopress_pro_sortable', array(
	'title'               => esc_html__('Homepage Sortable','corpopress-pro'),
	'description'         => esc_html__( 'Homepage Sortable options.', 'corpopress-pro' ),
	'panel'               => 'corpopress_pro_theme_options_panel',
) );

// Site layout setting and control.
$wp_customize->add_setting( 'corpopress_pro_theme_options[sortable]', array(
	'default'			  => $options['sortable'],
	'sanitize_callback'   => 'corpopress_pro_sanitize_sortable',
) );

$wp_customize->add_control( new Corpopress_Pro_Customize_Sortable_Control ( $wp_customize, 'corpopress_pro_theme_options[sortable]', array(
	'label'               => esc_html__( 'Sortable Homepage', 'corpopress-pro' ),
	'description'         => esc_html__( 'Drag and Drop to sort the sections according to your preference.', 'corpopress-pro' ),
	'section'             => 'corpopress_pro_sortable',
	'type'                => 'sortable',
	'choices'			  => corpopress_pro_sortable_sections(),
) ) );