<?php
/**
 * Typography options
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */

// Typography Section
$wp_customize->add_section( 'corpopress_pro_section_typography',
	array(
		'title'      		=> esc_html__( 'Typography', 'corpopress-pro' ),
		'priority'   		=> 600,
		'panel'      		=> 'corpopress_pro_theme_options_panel',
	)
);

// Theme typography setting and control.
$wp_customize->add_setting( 'corpopress_pro_theme_options[theme_typography]',
	array(
		'default'    		=> $options['theme_typography'],
		'sanitize_callback'	=> 'corpopress_pro_sanitize_select',
	)
);
$wp_customize->add_control( 'corpopress_pro_theme_options[theme_typography]',
    array(
		'label'       		=> esc_html__( 'Choose Heading Typography', 'corpopress-pro' ),
		'section'     		=> 'corpopress_pro_section_typography',
		'settings'    		=> 'corpopress_pro_theme_options[theme_typography]',
		'type'		  		=> 'select',
		'choices'			=> corpopress_pro_typography_options(),
    )
);

//Body Theme typography setting and control.
$wp_customize->add_setting( 'corpopress_pro_theme_options[body_theme_typography]',
	array(
		'default'    		=> $options['body_theme_typography'],
		'sanitize_callback'	=> 'corpopress_pro_sanitize_select',
	)
);
$wp_customize->add_control( 'corpopress_pro_theme_options[body_theme_typography]',
    array(
		'label'       		=> esc_html__( 'Choose Body Typography', 'corpopress-pro' ),
		'section'     		=> 'corpopress_pro_section_typography',
		'settings'    		=> 'corpopress_pro_theme_options[body_theme_typography]',
		'type'		  		=> 'select',
		'choices'			=> corpopress_pro_body_typography_options(),
    )
);