<?php
/**
* Customizer validation functions
*
* @package Theme Palace
* @subpackage Corpopress Pro
* @since Corpopress Pro 1.0.0
*/

if ( ! function_exists( 'corpopress_pro_validate_long_excerpt' ) ) :
  function corpopress_pro_validate_long_excerpt( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'corpopress-pro' ) );
     } elseif ( $value < 5 ) {
         $validity->add( 'min_no_of_words', esc_html__( 'Minimum no of words is 5', 'corpopress-pro' ) );
     } elseif ( $value > 100 ) {
         $validity->add( 'max_no_of_words', esc_html__( 'Maximum no of words is 100', 'corpopress-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'corpopress_pro_validate_slider_count' ) ) :
  function corpopress_pro_validate_slider_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'corpopress-pro' ) );
     } elseif ( $value < 1 ) {
         $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'corpopress-pro' ) );
     } elseif ( $value > 50 ) {
         $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 50', 'corpopress-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'corpopress_pro_validate_recent_count' ) ) :
  function corpopress_pro_validate_recent_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'corpopress-pro' ) );
     } elseif ( $value < 1 ) {
         $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'corpopress-pro' ) );
     } elseif ( $value > 50 ) {
         $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 50', 'corpopress-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'corpopress_pro_validate_service_count' ) ) :
  function corpopress_pro_validate_service_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'corpopress-pro' ) );
     } elseif ( $value < 2 ) {
         $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 2', 'corpopress-pro' ) );
     } elseif ( $value > 12 ) {
         $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 12', 'corpopress-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'corpopress_pro_validate_featured_count' ) ) :
  function corpopress_pro_validate_featured_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'corpopress-pro' ) );
     } elseif ( $value < 2 ) {
         $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 2', 'corpopress-pro' ) );
     } elseif ( $value > 12 ) {
         $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 12', 'corpopress-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'corpopress_pro_validate_testimonial_count' ) ) :
  function corpopress_pro_validate_testimonial_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'corpopress-pro' ) );
     } elseif ( $value < 1 ) {
         $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'corpopress-pro' ) );
     } elseif ( $value > 10 ) {
         $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 10', 'corpopress-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'corpopress_pro_validate_client_count' ) ) :
  function corpopress_pro_validate_client_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'corpopress-pro' ) );
     } elseif ( $value < 1 ) {
         $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'corpopress-pro' ) );
     } elseif ( $value > 12 ) {
         $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 12', 'corpopress-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'corpopress_pro_validate_team_count' ) ) :
  function corpopress_pro_validate_team_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'corpopress-pro' ) );
     } elseif ( $value < 1 ) {
         $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'corpopress-pro' ) );
     } elseif ( $value > 10 ) {
         $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 10', 'corpopress-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'corpopress_pro_validate_blog_count' ) ) :
  function corpopress_pro_validate_blog_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'corpopress-pro' ) );
     } elseif ( $value < 2 ) {
         $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 2', 'corpopress-pro' ) );
     } elseif ( $value > 50 ) {
         $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 50', 'corpopress-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'corpopress_pro_validate_popular_count' ) ) :
  function corpopress_pro_validate_popular_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'corpopress-pro' ) );
     } elseif ( $value < 2 ) {
         $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 2', 'corpopress-pro' ) );
     } elseif ( $value > 50 ) {
         $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 50', 'corpopress-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'corpopress_pro_validate_breaking_news_count' ) ) :
  function corpopress_pro_validate_breaking_news_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'corpopress-pro' ) );
     } elseif ( $value < 1 ) {
         $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'corpopress-pro' ) );
     } elseif ( $value > 50 ) {
         $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 50', 'corpopress-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'corpopress_pro_validate_highlighted_posts_count' ) ) :
  function corpopress_pro_validate_highlighted_posts_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'corpopress-pro' ) );
     } elseif ( $value < 1 ) {
         $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'corpopress-pro' ) );
     } elseif ( $value > 50 ) {
         $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 50', 'corpopress-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'corpopress_pro_validate_most_popular_count' ) ) :
  function corpopress_pro_validate_most_popular_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'corpopress-pro' ) );
     } elseif ( $value < 1 ) {
         $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'corpopress-pro' ) );
     } elseif ( $value > 50 ) {
         $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 50', 'corpopress-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'corpopress_pro_validate_politics_count' ) ) :
  function corpopress_pro_validate_politics_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'corpopress-pro' ) );
     } elseif ( $value < 1 ) {
         $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'corpopress-pro' ) );
     } elseif ( $value > 50 ) {
         $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 50', 'corpopress-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'corpopress_pro_validate_sports_count' ) ) :
  function corpopress_pro_validate_sports_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'corpopress-pro' ) );
     } elseif ( $value < 1 ) {
         $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'corpopress-pro' ) );
     } elseif ( $value > 50 ) {
         $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 50', 'corpopress-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'corpopress_pro_validate_two_column_count' ) ) :
  function corpopress_pro_validate_two_column_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'corpopress-pro' ) );
     } elseif ( $value < 1 ) {
         $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'corpopress-pro' ) );
     } elseif ( $value > 50 ) {
         $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 50', 'corpopress-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'corpopress_pro_validate_latest_products_count' ) ) :
  function corpopress_pro_validate_latest_products_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'corpopress-pro' ) );
     } elseif ( $value < 1 ) {
         $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'corpopress-pro' ) );
     } elseif ( $value > 50 ) {
         $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 50', 'corpopress-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'corpopress_pro_validate_popular_products_count' ) ) :
  function corpopress_pro_validate_popular_products_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'corpopress-pro' ) );
     } elseif ( $value < 1 ) {
         $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'corpopress-pro' ) );
     } elseif ( $value > 50 ) {
         $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 50', 'corpopress-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'corpopress_pro_validate_collection_count' ) ) :
  function corpopress_pro_validate_collection_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'corpopress-pro' ) );
     } elseif ( $value < 1 ) {
         $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'corpopress-pro' ) );
     } elseif ( $value > 50 ) {
         $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 50', 'corpopress-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'corpopress_pro_validate_featured_products_count' ) ) :
  function corpopress_pro_validate_featured_products_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'corpopress-pro' ) );
     } elseif ( $value < 2 ) {
         $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 2', 'corpopress-pro' ) );
     } elseif ( $value > 30 ) {
         $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 30', 'corpopress-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'corpopress_pro_validate_recent_products_count' ) ) :
  function corpopress_pro_validate_recent_products_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'corpopress-pro' ) );
     } elseif ( $value < 1 ) {
         $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'corpopress-pro' ) );
     } elseif ( $value > 50 ) {
         $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 50', 'corpopress-pro' ) );
     }
     return $validity;
  }
endif;