<?php
/**
 * Theme Palace options
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */

/**
 * List of pages for page choices.
 * @return Array Array of page ids and name.
 */
function corpopress_pro_page_choices() {
    $pages = get_pages();
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'corpopress-pro' );
    foreach ( $pages as $page ) {
        $choices[ $page->ID ] = $page->post_title;
    }
    return  $choices;
}

/**
 * List of posts for post choices.
 * @return Array Array of post ids and name.
 */
function corpopress_pro_post_choices() {
    $posts = get_posts( array( 'numberposts' => -1 ) );
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'corpopress-pro' );
    foreach ( $posts as $post ) {
        $choices[ $post->ID ] = $post->post_title;
    }
    return  $choices;
}

if ( ! function_exists( 'corpopress_pro_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function corpopress_pro_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'corpopress-pro' ),
            'header-font-1'   => esc_html__( 'Rajdhani', 'corpopress-pro' ),
            'header-font-2'   => esc_html__( 'Cherry Swash', 'corpopress-pro' ),
            'header-font-3'   => esc_html__( 'Philosopher', 'corpopress-pro' ),
            'header-font-4'   => esc_html__( 'Slabo 27px', 'corpopress-pro' ),
            'header-font-5'   => esc_html__( 'Dosis', 'corpopress-pro' ),
        );

        $output = apply_filters( 'corpopress_pro_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

function corpopress_pro_product_choices() {
    $full_product_list = array();
    $product_id = array();
    $loop = new WP_Query(array('post_type' => array('product', 'product_variation'), 'posts_per_page' => -1));
    while ($loop->have_posts()) : $loop->the_post();
        $product_id[] = get_the_id();
    endwhile;
    wp_reset_postdata();
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'corpopress-pro' );
    foreach ( $product_id  as $id ) {
        $choices[ $id ] = get_the_title( $id );
    }
    return  $choices;
}


if ( ! function_exists( 'corpopress_pro_body_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function corpopress_pro_body_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'corpopress-pro' ),
            'body-font-1'     => esc_html__( 'News Cycle', 'corpopress-pro' ),
            'body-font-2'     => esc_html__( 'Pontano Sans', 'corpopress-pro' ),
            'body-font-3'     => esc_html__( 'Gudea', 'corpopress-pro' ),
            'body-font-4'     => esc_html__( 'Quattrocento', 'corpopress-pro' ),
            'body-font-5'     => esc_html__( 'Khand', 'corpopress-pro' ),
        );

        $output = apply_filters( 'corpopress_pro_body_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;


if ( ! function_exists( 'corpopress_pro_site_layout' ) ) :
    /**
     * Site Layout
     * @return array site layout options
     */
    function corpopress_pro_site_layout() {
        $corpopress_pro_site_layout = array(
            'wide'  => get_template_directory_uri() . '/assets/images/full.png',
            'boxed-layout' => get_template_directory_uri() . '/assets/images/boxed.png',
        );

        $output = apply_filters( 'corpopress_pro_site_layout', $corpopress_pro_site_layout );
        return $output;
    }
endif;

if ( ! function_exists( 'corpopress_pro_selected_sidebar' ) ) :
    /**
     * Sidebars options
     * @return array Sidbar positions
     */
    function corpopress_pro_selected_sidebar() {
        $corpopress_pro_selected_sidebar = array(
            'sidebar-1'             => esc_html__( 'Default Sidebar', 'corpopress-pro' ),
            'optional-sidebar'      => esc_html__( 'Optional Sidebar 1', 'corpopress-pro' ),
            'optional-sidebar-2'    => esc_html__( 'Optional Sidebar 2', 'corpopress-pro' ),
            'optional-sidebar-3'    => esc_html__( 'Optional Sidebar 3', 'corpopress-pro' ),
            'optional-sidebar-4'    => esc_html__( 'Optional Sidebar 4', 'corpopress-pro' ),
        );

        $output = apply_filters( 'corpopress_pro_selected_sidebar', $corpopress_pro_selected_sidebar );

        return $output;
    }
endif;


if ( ! function_exists( 'corpopress_pro_global_sidebar_position' ) ) :
    /**
     * Global Sidebar position
     * @return array Global Sidebar positions
     */
    function corpopress_pro_global_sidebar_position() {
        $corpopress_pro_global_sidebar_position = array(
            'right-sidebar' => get_template_directory_uri() . '/assets/images/right.png',
            'left-sidebar'  => get_template_directory_uri() . '/assets/images/left.png',
            'no-sidebar'    => get_template_directory_uri() . '/assets/images/full.png',
        );

        $output = apply_filters( 'corpopress_pro_global_sidebar_position', $corpopress_pro_global_sidebar_position );

        return $output;
    }
endif;


if ( ! function_exists( 'corpopress_pro_sidebar_position' ) ) :
    /**
     * Sidebar position
     * @return array Sidbar positions
     */
    function corpopress_pro_sidebar_position() {
        $corpopress_pro_sidebar_position = array(
            'right-sidebar' => get_template_directory_uri() . '/assets/images/right.png',
            'left-sidebar'  => get_template_directory_uri() . '/assets/images/left.png',
            'no-sidebar'    => get_template_directory_uri() . '/assets/images/full.png',
            'no-sidebar-content'   => get_template_directory_uri() . '/assets/images/boxed.png',
        );

        $output = apply_filters( 'corpopress_pro_sidebar_position', $corpopress_pro_sidebar_position );

        return $output;
    }
endif;


if ( ! function_exists( 'corpopress_pro_pagination_options' ) ) :
    /**
     * Pagination
     * @return array site pagination options
     */
    function corpopress_pro_pagination_options() {
        $corpopress_pro_pagination_options = array(
            'numeric'   => esc_html__( 'Numeric', 'corpopress-pro' ),
            'default'   => esc_html__( 'Default(Older/Newer)', 'corpopress-pro' ),
            'infinite'  => esc_html__( 'Infinite', 'corpopress-pro' ),
        );

        $output = apply_filters( 'corpopress_pro_pagination_options', $corpopress_pro_pagination_options );

        return $output;
    }
endif;

if ( ! function_exists( 'corpopress_pro_get_spinner_list' ) ) :
    /**
     * List of spinner icons options.
     * @return array List of all spinner icon options.
     */
    function corpopress_pro_get_spinner_list() {
        $arr = array(
            'default'               => esc_html__( 'Default', 'corpopress-pro' ),
            'spinner-wheel'         => esc_html__( 'Wheel', 'corpopress-pro' ),
            'spinner-double-circle' => esc_html__( 'Double Circle', 'corpopress-pro' ),
            'spinner-two-way'       => esc_html__( 'Two Way', 'corpopress-pro' ),
            'spinner-umbrella'      => esc_html__( 'Umbrella', 'corpopress-pro' ),
            'spinner-circle'        => esc_html__( 'Circle', 'corpopress-pro' ),
            'spinner-dots'          => esc_html__( 'Dots', 'corpopress-pro' ),
            'spinner-one-way'       => esc_html__( 'One Way', 'corpopress-pro' ),
            'spinner-fidget'        => esc_html__( 'Fidget', 'corpopress-pro' ),
        );
        return apply_filters( 'corpopress_pro_spinner_list', $arr );
    }
endif;

if ( ! function_exists( 'corpopress_pro_switch_options' ) ) :
    /**
     * List of custom Switch Control options
     * @return array List of switch control options.
     */
    function corpopress_pro_switch_options() {
        $arr = array(
            'on'        => esc_html__( 'Enable', 'corpopress-pro' ),
            'off'       => esc_html__( 'Disable', 'corpopress-pro' )
        );
        return apply_filters( 'corpopress_pro_switch_options', $arr );
    }
endif;

if ( ! function_exists( 'corpopress_pro_hide_options' ) ) :
    /**
     * List of custom Switch Control options
     * @return array List of switch control options.
     */
    function corpopress_pro_hide_options() {
        $arr = array(
            'on'        => esc_html__( 'Yes', 'corpopress-pro' ),
            'off'       => esc_html__( 'No', 'corpopress-pro' )
        );
        return apply_filters( 'corpopress_pro_hide_options', $arr );
    }
endif;

if ( ! function_exists( 'corpopress_pro_sortable_sections' ) ) :
    /**
     * List of sections Control options
     * @return array List of Sections control options.
     */
    function corpopress_pro_sortable_sections() {
        $sections = array(
            'slider'        => esc_html__( 'Main Slider', 'corpopress-pro' ),
            'about'         => esc_html__( 'About Us', 'corpopress-pro' ),
            'cta'           => esc_html__( 'Call to Action', 'corpopress-pro' ),
            'service'       => esc_html__( 'Services', 'corpopress-pro' ),
            'featured'      => esc_html__( 'Featured', 'corpopress-pro' ),
            'counter'       => esc_html__( 'Counter', 'corpopress-pro' ),
            'promotion'     => esc_html__( 'Promotion', 'corpopress-pro' ),
            'testimonial'   => esc_html__( 'Testimonial', 'corpopress-pro' ),
            'client'        => esc_html__( 'Client', 'corpopress-pro' ),
            'team'          => esc_html__( 'Team', 'corpopress-pro' ),
            'blog'          => esc_html__( 'Blog', 'corpopress-pro' ),
            'subscription'  => esc_html__( 'Subscription', 'corpopress-pro' ),
            'recent'        => esc_html__( 'Recent', 'corpopress-pro' ),
            'sponsor'       => esc_html__( 'Sponsor', 'corpopress-pro' ),
            'popular'       => esc_html__( 'Popular Posts', 'corpopress-pro' ),
            'most_viewed'   => esc_html__( 'Most Viewed Posts', 'corpopress-pro' ),
            'breaking_news' => esc_html__( 'Breaking News', 'corpopress-pro' ),
            'highlighted_posts' => esc_html__( 'Highlighted Posts', 'corpopress-pro' ),
            'most_popular' => esc_html__( 'Most Popular', 'corpopress-pro' ),
            'politics' => esc_html__( 'Politics', 'corpopress-pro' ),
            'sports' => esc_html__( 'Sports', 'corpopress-pro' ),
            'two_column' => esc_html__( 'Two Column', 'corpopress-pro' ),
            'latest_products' => esc_html__( 'Latest Products', 'corpopress-pro' ),
            'popular_products' => esc_html__( 'Popular Products', 'corpopress-pro' ),
            'collection' => esc_html__( 'Products Collection', 'corpopress-pro' ),
            'featured_products' => esc_html__( 'Featured Products', 'corpopress-pro' ),
            'recent_products' => esc_html__( 'Recent Products', 'corpopress-pro' ),
        );
        return apply_filters( 'corpopress_pro_sortable_sections', $sections );
    }
endif;