<?php
/**
 * Blog section
 *
 * This is the template for the content of blog section
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */
if ( ! function_exists( 'corpopress_pro_add_blog_section' ) ) :
    /**
    * Add blog section
    *
    *@since Corpopress Pro 1.0.0
    */
    function corpopress_pro_add_blog_section() {
    	$options = corpopress_pro_get_theme_options();
        // Check if blog is enabled on frontpage
        $blog_enable = apply_filters( 'corpopress_pro_section_status', true, 'blog_section_enable' );

        if ( true !== $blog_enable ) {
            return false;
        }
        // Get blog section details
        $section_details = array();
        $section_details = apply_filters( 'corpopress_pro_filter_blog_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render blog section now.
        corpopress_pro_render_blog_section( $section_details );
    }
endif;

if ( ! function_exists( 'corpopress_pro_get_blog_section_details' ) ) :
    /**
    * blog section details.
    *
    * @since Corpopress Pro 1.0.0
    * @param array $input blog section details.
    */
    function corpopress_pro_get_blog_section_details( $input ) {
        $options = corpopress_pro_get_theme_options();

        // Content type.
        $blog_content_type  = $options['blog_content_type'];
        $blog_count = ! empty( $options['blog_count'] ) ? $options['blog_count'] : 4;
        
        $content = array();
        switch ( $blog_content_type ) {
        	
            case 'page':
                $page_ids = array();

                for ( $i = 1; $i <= $blog_count; $i++ ) {
                    if ( ! empty( $options['blog_content_page_' . $i] ) )
                        $page_ids[] = $options['blog_content_page_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'page',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $blog_count ),
                    'orderby'           => 'post__in',
                    );                    
            break;

            case 'post':
                $post_ids = array();

                for ( $i = 1; $i <= $blog_count; $i++ ) {
                    if ( ! empty( $options['blog_content_post_' . $i] ) )
                        $post_ids[] = $options['blog_content_post_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'post',
                    'post__in'          => ( array ) $post_ids,
                    'posts_per_page'    => absint( $blog_count ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'category':
                $cat_id = ! empty( $options['blog_content_category'] ) ? $options['blog_content_category'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $blog_count ),
                    'cat'               => absint( $cat_id ),
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'recent':
                $cat_ids = ! empty( $options['blog_category_exclude'] ) ? $options['blog_category_exclude'] : array();
                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $blog_count ),
                    'category__not_in'  => ( array ) $cat_ids,
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            default:
            break;
        }


        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['excerpt']   = corpopress_pro_trim_content( 20 );
                $page_post['image']  	= has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'post-thumbnail' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';
                $page_post['auth_id']    = get_the_author_meta('ID');

                // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// blog section content details.
add_filter( 'corpopress_pro_filter_blog_section_details', 'corpopress_pro_get_blog_section_details' );


if ( ! function_exists( 'corpopress_pro_render_blog_section' ) ) :
  /**
   * Start blog section
   *
   * @return string blog content
   * @since Corpopress Pro 1.0.0
   *
   */
   function corpopress_pro_render_blog_section( $content_details = array() ) {
        $options = corpopress_pro_get_theme_options();
        $column = ! empty( $options['blog_column'] ) ? $options['blog_column'] : 'col-3';
        $readmore = ! empty( $options['read_more_text'] ) ? $options['read_more_text'] : esc_html__( 'Read More', 'corpopress-pro' );

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="corpopress_pro_blog_section">

        <div id="blog" class="page-section <?php echo esc_attr( $column ); ?>">
            <div class="wrapper">

                <?php if ( ! empty( $options['blog_title'] ) ) : ?>
                    <div class="section-header clear">
                        <h2 class="section-title"><?php echo esc_html( $options['blog_title'] ); ?></h2>
                    </div>
                <?php endif; ?>

                <div class="section-content">
                    <?php foreach ( $content_details as $content ) : 
                    $class = has_post_thumbnail( $content['id'] ) ? '' : 'no-post-thumbnail'; ?>
                        <article class="hentry <?php echo esc_attr( $class ); ?>">
                            <div class="blog-wrapper">
                                <?php if ( $options['blog_author_enable'] ) : ?>
                                    <div class="header-meta">
                                        <?php echo corpopress_pro_blog_author( $content['auth_id'] ); ?>
                                    </div><!-- .header-meta -->
                                <?php endif; ?>

                                <div class="featured-image">
                                    <?php if ( ! empty( $content['image'] ) ) : ?>
                                        <a href="<?php echo esc_url( $content['url'] ); ?>"><img src="<?php echo esc_url( $content['image'] ); ?>" alt="<?php echo esc_attr( $content['title'] ); ?>"></a>
                                    <?php endif; ?>
                                    <div class="entry-meta">
                                        <?php corpopress_pro_posted_on( $content['id'] ); ?> 
                                    </div><!-- .entry-meta -->
                                </div><!-- .featured-image -->

                                <div class="entry-container">
                                    <header class="entry-header">
                                        <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                    </header>
                                    <div class="entry-content">
                                        <p>
                                            <?php echo esc_html( $content['excerpt'] ); ?>
                                            <span>
                                                <a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $readmore ); ?></a>
                                            </span>
                                        </p>
                                    </div><!-- .entry-content -->
                                </div><!-- .entry-container -->
                            </div><!-- .blog-wrapper -->
                        </article><!-- .hentry -->
                    <?php endforeach; ?>
                </div><!-- .section-content -->
            </div><!-- .wrappper -->
        </div><!-- #blog -->

        </div>

    <?php }
endif;