<?php
/**
 * Client section
 *
 * This is the template for the content of client section
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */
if ( ! function_exists( 'corpopress_pro_add_client_section' ) ) :
    /**
    * Add client section
    *
    *@since Corpopress Pro 1.0.0
    */
    function corpopress_pro_add_client_section() {
    	$options = corpopress_pro_get_theme_options();
        // Check if client is enabled on frontpage
        $client_enable = apply_filters( 'corpopress_pro_section_status', true, 'client_section_enable' );

        if ( true !== $client_enable ) {
            return false;
        }
        // Get client section details
        $section_details = array();
        $section_details = apply_filters( 'corpopress_pro_filter_client_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render client section now.
        corpopress_pro_render_client_section( $section_details );
    }
endif;

if ( ! function_exists( 'corpopress_pro_get_client_section_details' ) ) :
    /**
    * client section details.
    *
    * @since Corpopress Pro 1.0.0
    * @param array $input client section details.
    */
    function corpopress_pro_get_client_section_details( $input ) {
        $options = corpopress_pro_get_theme_options();

        // Content type.
        $client_content_type  = $options['client_content_type'];
        $client_count = ! empty( $options['client_count'] ) ? $options['client_count'] : 3;
        
        $content = array();
        switch ( $client_content_type ) {
        	
            case 'page':
                $page_ids = array();

                for ( $i = 1; $i <= $client_count; $i++ ) {
                    if ( ! empty( $options['client_content_page_' . $i] ) )
                        $page_ids[] = $options['client_content_page_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'page',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $client_count ),
                    'orderby'           => 'post__in',
                    );                    
            break;

            case 'post':
                $post_ids = array();

                for ( $i = 1; $i <= $client_count; $i++ ) {
                    if ( ! empty( $options['client_content_post_' . $i] ) )
                        $post_ids[] = $options['client_content_post_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'post',
                    'post__in'          => ( array ) $post_ids,
                    'posts_per_page'    => absint( $client_count ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'category':
                $cat_id = ! empty( $options['client_content_category'] ) ? $options['client_content_category'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $client_count ),
                    'cat'               => absint( $cat_id ),
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'custom':
                for ( $i = 1; $i <= $client_count; $i++ ) {
                    $custom['image']        = ! empty( $options['client_image_' . $i] ) ? $options['client_image_' . $i] : '';
                    $custom['title']        = ! empty( $options['client_title_' . $i] ) ? $options['client_title_' . $i] : '';
                    $custom['url']          = ! empty( $options['client_link_' . $i] ) ? $options['client_link_' . $i] : '';

                    // Push to the main array.
                    array_push( $content, $custom );
                }
            break;


            default:
            break;
        }

        if ( 'custom' !== $client_content_type ) {
            // Run The Loop.
            $query = new WP_Query( $args );
            $i = 0;
            if ( $query->have_posts() ) : 
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['title']     = get_the_title();
                    $page_post['url']       = get_the_permalink();
                    $page_post['image']  	= has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'medium' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';

                    // Push to the main array.
                    array_push( $content, $page_post );
                    $i++;
                endwhile;
            endif;
            wp_reset_postdata();
        }
            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// client section content details.
add_filter( 'corpopress_pro_filter_client_section_details', 'corpopress_pro_get_client_section_details' );


if ( ! function_exists( 'corpopress_pro_render_client_section' ) ) :
  /**
   * Start client section
   *
   * @return string client content
   * @since Corpopress Pro 1.0.0
   *
   */
   function corpopress_pro_render_client_section( $content_details = array() ) {
        $options = corpopress_pro_get_theme_options();
        $column = ! empty( $options['client_column'] ) ? $options['client_column'] : 5;
        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="corpopress_pro_client_section">

        <div id="client-slider" class="page-section no-padding-top">
            <div class="wrapper">
                <div class="logo-slider" data-slick='{"slidesToShow": <?php echo absint( $column ); ?>, "slidesToScroll": 1, "infinite": true, "speed": 1000, "dots": false, "arrows":false, "autoplay": true, "fade": false }'>
                    <?php foreach ( $content_details as $content ) : 
                        if ( ! empty( $content['image'] ) ) : ?>
                            <a href="<?php echo esc_url( $content['url'] ); ?>"><img src="<?php echo esc_url( $content['image'] ); ?>" title="<?php echo esc_attr( $content['title'] ); ?>" alt="<?php echo esc_attr( $content['title'] ); ?>"></a>
                        <?php endif; 
                    endforeach; ?>
                </div><!-- .testimonial-slider -->
            </div><!-- .wrapper -->
        </div><!-- #our-partners -->

        </div>

    <?php }
endif;