<?php
/**
 * Collection section
 *
 * This is the template for the content of Collection section
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */
if ( ! function_exists( 'corpopress_pro_add_collection_section' ) ) :
    /**
    * Add Collection section
    *
    *@since Corpopress Pro 1.0.0
    */
    function corpopress_pro_add_collection_section() {
    	$options = corpopress_pro_get_theme_options();
        // Check if Collection is enabled on frontpage
        $collection_enable = apply_filters( 'corpopress_pro_section_status', true, 'collection_section_enable' );

        if ( ( true !== $collection_enable) || ! class_exists( 'WooCommerce' ) ) {
            return false;
        }

        // Render Collection section now.
        corpopress_pro_render_collection_section();
    }
endif;

if ( ! function_exists( 'corpopress_pro_render_collection_section' ) ) :
  /**
   * Start Collection section
   *
   * @return string Collection content
   * @since Corpopress Pro 1.0.0
   *
   */
   function corpopress_pro_render_collection_section() {
        $options = corpopress_pro_get_theme_options();
    ?>

    <div id="corpopress_pro_collection_section" class="relative page-section same-background">

    <div id="magazine-poltics-posts">
        <div class="wrapper">
            <div class="col-3 grid clear">

                <?php for ( $i=1; $i <= $options['collection_count'] ; $i++ ) { 
                    if ( empty($options['collection_content_product_category_'.$i]) ) {
                        continue;
                    }
                    $thumbnail_id = get_term_meta( $options['collection_content_product_category_'.$i], 'thumbnail_id', true );
                    $image = wp_get_attachment_url( $thumbnail_id );
                    $cat_name = get_term_by( 'id', $options['collection_content_product_category_'.$i], 'product_cat' )->name;
                    $cat_count = get_term_by( 'id', $options['collection_content_product_category_'.$i], 'product_cat' )->count;
                    $cat_link = get_category_link( $options['collection_content_product_category_'.$i] );

                    ?>

                    <article class="grid-item">
                        <div class="highlighted-post-item">
                            <div class="featured-image">
                                <div class="overlay"></div>
                                <img src="<?php echo esc_url( $image ); ?>">
                            </div><!-- .featured-image -->

                            <div class="entry-container">
                                <header class="entry-header">
                                    <h2 class="entry-title"><a href="<?php echo esc_url( $cat_link ); ?>"><?php echo esc_html( $cat_name ); ?></a></h2>
                                    <span> <?php echo absint( $cat_count ); ?> <?php echo esc_html__( 'items', 'corpopress-pro' ); ?></span>
                                </header>   
                            </div><!-- .entry-container -->
                        </div><!-- .highlighted-post-item -->
                    </article>

                    <?php } ?>

                </div><!-- .col-3 -->
            </div><!-- .wrapper -->
        </div>

        </div>
    
    <?php }
endif;