<?php
/**
 * Counter section
 *
 * This is the template for the content of counter section
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */
if ( ! function_exists( 'corpopress_pro_add_counter_section' ) ) :
    /**
    * Add counter section
    *
    *@since Corpopress Pro 1.0.0
    */
    function corpopress_pro_add_counter_section() {
    	$options = corpopress_pro_get_theme_options();
        // Check if counter is enabled on frontpage
        $counter_enable = apply_filters( 'corpopress_pro_section_status', true, 'counter_section_enable' );

        if ( true !== $counter_enable ) {
            return false;
        }

        // Render counter section now.
        corpopress_pro_render_counter_section();
    }
endif;

if ( ! function_exists( 'corpopress_pro_render_counter_section' ) ) :
  /**
   * Start counter section
   *
   * @return string counter content
   * @since Corpopress Pro 1.0.0
   *
   */
   function corpopress_pro_render_counter_section() {
        $options = corpopress_pro_get_theme_options();
        $count = 1;
        for ( $i=1; $i <= 4 ; $i++ ) { 
            if ( ! empty( $options['counter_title_' . $i] ) && ! empty( $options['counter_value_' . $i] ) )
                $count = $i;
        }
        ?>

        <div id="corpopress_pro_counter_section">

        <div id="counter" class="col-<?php echo absint( $count ); ?> page-section no-padding-top">
            <div class="wrapper">
                <?php for ( $i = 1; $i <= 4; $i++ ) : 
                    if ( ! empty( $options['counter_title_' . $i] ) && ! empty( $options['counter_value_' . $i] ) ) : ?>
                        <div class="hentry">
                            <i class="fa <?php echo ! empty( $options['counter_icon_' . $i] ) ? esc_attr( $options['counter_icon_' . $i] ) : 'fa-laptop' ?>" ></i>
                            <span><?php echo esc_html( $options['counter_value_' . $i] ); ?></span>
                            <p><?php echo esc_html( $options['counter_title_' . $i] ); ?></p>
                        </div><!-- .hentry -->
                    <?php endif; 
                endfor; ?>
            </div><!-- .wapper -->
        </div><!-- #counter -->

        </div>
        
    <?php }
endif;