<?php
/**
 * featured_products section
 *
 * This is the template for the content of featured_products section
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */
if ( ! function_exists( 'corpopress_pro_add_featured_products_section' ) ) :
    /**
    * Add featured_products section
    *
    *@since Corpopress Pro 1.0.0
    */
    function corpopress_pro_add_featured_products_section() {
        $options = corpopress_pro_get_theme_options();
        // Check if featured_products is enabled on frontpage
        $featured_products_enable = apply_filters( 'corpopress_pro_section_status', true, 'featured_products_section_enable' );

        if ( ( true !== $featured_products_enable) || ! class_exists( 'WooCommerce' ) ) {
            return false;
        }

        // Render featured_products section now.
        corpopress_pro_render_featured_products_section();
    }
endif;

if ( ! function_exists( 'corpopress_pro_render_featured_products_section' ) ) :
  /**
   * Start featured_products section
   *
   * @return string featured_products content
   * @since Corpopress Pro 1.0.0
   *
   */
   function corpopress_pro_render_featured_products_section() {
        $options = corpopress_pro_get_theme_options();

    ?>

    <div id="corpopress_pro_featured_products_section" class="relative page-section same-background">

    <div id="featured-products">
        <div class="wrapper">
            <div class="section-content clear col-2">

                <?php for ( $i=1; $i <= $options['featured_products_count']; $i++ ) { 
                    if ( empty($options['featured_products_content_product_category_'.$i]) ) {
                        continue;
                    }
                    $thumbnail_id = get_term_meta( $options['featured_products_content_product_category_'.$i], 'thumbnail_id', true );
                    $image = wp_get_attachment_url( $thumbnail_id );
                    $cat_name = get_term_by( 'id', $options['featured_products_content_product_category_'.$i], 'product_cat' )->name;
                    $banner_title = empty( $options['featured_products_banner_title_'.$i] ) ? '' : $options['featured_products_banner_title_'.$i];

                    $banner_description = empty( $options['featured_products_banner_description_'.$i] ) ? '' : $options['featured_products_banner_description_'.$i];

                    $banner_btn = empty( $options['featured_products_button_'.$i] ) ? '' : $options['featured_products_button_'.$i];

                    $cat_link = get_category_link( $options['featured_products_content_product_category_'.$i] );
                    ?>

                    <article>
                        <div class="featured-image" style="background-image: url('<?php echo esc_url( $image ); ?>');">
                            <div class="entry-container">
                                <span class="cat-links">
                                    <ul class="post-categories">
                                        <li><a href="<?php echo esc_url( $cat_link ); ?>"><?php echo esc_html( $cat_name ); ?></a></li>
                                    </ul>
                                </span><!-- .cat-links -->

                                <header class="entry-header">
                                    <h2 class="entry-title"><a href="<?php echo esc_url( $cat_link ); ?>"><?php echo esc_html( $banner_title ); ?></a></h2>
                                </header>

                                <div class="entry-content">
                                    <p><?php echo esc_html( $banner_description ); ?></p>
                                </div><!-- .entry-content -->

                                <?php if( !empty( $banner_btn ) ): ?>

                                    <div class="read-more">
                                        <a href="<?php echo esc_url( $cat_link ); ?>" class="btn"><?php echo esc_html( $banner_btn ); ?></a>
                                    </div><!-- .read-more -->

                                <?php endif; ?>

                            </div><!-- .entry-container -->
                        </div><!-- .featured-image -->
                    </article>

                    <?php } ?>

                </div><!-- .section-content -->
            </div><!-- .wrapper -->
        </div>

        </div>

    <?php }
endif;