<?php
/**
 * latest_products section
 *
 * This is the template for the content of latest_products section
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */
if ( ! function_exists( 'corpopress_pro_add_latest_products_section' ) ) :
    /**
    * Add latest_products section
    *
    *@since Corpopress Pro 1.0.0
    */
    function corpopress_pro_add_latest_products_section() {
        $options = corpopress_pro_get_theme_options();
        // Check if latest_products is enabled on frontpage
        $latest_products_enable = apply_filters( 'corpopress_pro_section_status', true, 'latest_products_section_enable' );

        if ( ( true !== $latest_products_enable ) || ! class_exists( 'WooCommerce' ) ) {
            return false;
        }
        // Get latest_products section details
        $section_details = array();
        $section_details = apply_filters( 'corpopress_pro_filter_latest_products_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render latest_products section now.
        corpopress_pro_render_latest_products_section( $section_details );
    }
endif;

if ( ! function_exists( 'corpopress_pro_get_latest_products_section_details' ) ) :
    /**
    * latest_products section details.
    *
    * @since Corpopress Pro 1.0.0
    * @param array $input latest_products section details.
    */
    function corpopress_pro_get_latest_products_section_details( $input ) {
        $options = corpopress_pro_get_theme_options();

        // Content type.
        $latest_products_content_type  = $options['latest_products_content_type'];    
        $latest_products_count = !empty( $options['latest_products_count'] ) ? $options['latest_products_count'] : 4;
        
        $content = array();
        $content = array();
        switch ( $latest_products_content_type ) {

            case 'product':
                $page_ids = array();

                for ( $i = 1; $i <= $latest_products_count; $i++ ) {
                    if ( ! empty( $options['latest_products_content_product_' . $i] ) )
                        $page_ids[] = $options['latest_products_content_product_' . $i];
                }

                $args = array(
                    'post_type'         => 'product',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $latest_products_count ),
                    'orderby'           => 'post__in',
                    );
            break;
            case 'product-category':
                $cat_id = ! empty( $options['latest_products_content_product_category'] ) ? $options['latest_products_content_product_category'] : '';

                $args = array(
                'post_type'         => 'product',
                'posts_per_page'    => absint( $latest_products_count ),
                'tax_query'         => array(
                    array(
                        'taxonomy'  => 'product_cat',
                        'field'     => 'id',
                        'terms'     => $cat_id
                    )
                ) );
            break;

            default:
            break;
        }

        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'large' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';

                // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// latest_products section content details.
add_filter( 'corpopress_pro_filter_latest_products_section_details', 'corpopress_pro_get_latest_products_section_details' );

if ( ! function_exists( 'corpopress_pro_render_latest_products_section' ) ) :
  /**
   * Start latest_products section
   *
   * @return string latest_products content
   * @since Corpopress Pro 1.0.0
   *
   */
   function corpopress_pro_render_latest_products_section( $content_details = array() ) {
        $options = corpopress_pro_get_theme_options();

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="corpopress_pro_latest_products_section" class="relative page-section same-background">
       
        <div id="latest-products">
                <div class="wrapper">
                    <div class="<?php echo esc_attr( $options['latest_products_col_layout'] ); ?> clear">

                    <?php $i=1; foreach ($content_details as $content ): ?>

                        <article>
                            <div class="featured-image" style="background-image: url('<?php echo esc_url( $content['image'] ); ?>');">
                                <div class="overlay"></div>
                                <div class="entry-container">
                                    <header class="entry-header">
                                    <?php if( !empty( $options['latest_products_sub_title_' . $i] ) ): ?>
                                        <span><?php echo esc_html( $options['latest_products_sub_title_' . $i] ); ?></span>
                                    <?php endif; ?>
                                        <h2 class="entry-title"><?php echo esc_html( $content['title'] ); ?></h2>
                                    </header>

                                    <?php if( !empty( $options['latest_products_button'] ) ): ?>

                                    <a href="<?php echo esc_url( $content['url'] ); ?>" class="more-link"><?php echo esc_html( $options['latest_products_button'] ); ?></a>
                                <?php endif; ?>
                                </div><!-- .entry-container -->
                            </div><!-- .featured-image -->
                        </article>
                        
                    <?php $i++; endforeach; ?>

                    </div><!-- .grid --> 
                </div><!-- .wrapper -->
            </div>

            </div>
       
    <?php }
endif;