<?php
/**
 * Most Popular section
 *
 * This is the template for the content of most_popular section
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */
if ( ! function_exists( 'corpopress_pro_add_most_popular_section' ) ) :
    /**
    * Add most_popular section
    *
    *@since Corpopress Pro 1.0.0
    */
    function corpopress_pro_add_most_popular_section() {
    	$options = corpopress_pro_get_theme_options();
        // Check if most_popular is enabled on frontpage
        $most_popular_enable = apply_filters( 'corpopress_pro_section_status', true, 'most_popular_section_enable' );

        if ( true !== $most_popular_enable ) {
            return false;
        }
        // Get most_popular section details
        $section_details = array();
        $section_details = apply_filters( 'corpopress_pro_filter_most_popular_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render most_popular section now.
        corpopress_pro_render_most_popular_section( $section_details );
    }
endif;

if ( ! function_exists( 'corpopress_pro_get_most_popular_section_details' ) ) :
    /**
    * most_popular section details.
    *
    * @since Corpopress Pro 1.0.0
    * @param array $input most_popular section details.
    */
    function corpopress_pro_get_most_popular_section_details( $input ) {
        $options = corpopress_pro_get_theme_options();

        // Content type.
        $most_popular_content_type  = $options['most_popular_content_type'];
        $most_popular_count = ! empty( $options['most_popular_count'] ) ? $options['most_popular_count'] : 4;
        
        $content = array();
        switch ( $most_popular_content_type ) {
        	
            case 'page':
                $page_ids = array();

                for ( $i = 1; $i <= $most_popular_count; $i++ ) {
                    if ( ! empty( $options['most_popular_content_page_' . $i] ) )
                        $page_ids[] = $options['most_popular_content_page_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'page',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $most_popular_count ),
                    'orderby'           => 'post__in',
                    );                    
            break;

            case 'post':
                $post_ids = array();

                for ( $i = 1; $i <= $most_popular_count; $i++ ) {
                    if ( ! empty( $options['most_popular_content_post_' . $i] ) )
                        $post_ids[] = $options['most_popular_content_post_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'post',
                    'post__in'          => ( array ) $post_ids,
                    'posts_per_page'    => absint( $most_popular_count ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'category':
                $cat_id = ! empty( $options['most_popular_content_category'] ) ? $options['most_popular_content_category'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $most_popular_count ),
                    'cat'               => absint( $cat_id ),
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            default:
            break;
        }


        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['image']  	= has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'post-thumbnail' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';

                // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// most_popular section content details.
add_filter( 'corpopress_pro_filter_most_popular_section_details', 'corpopress_pro_get_most_popular_section_details' );


if ( ! function_exists( 'corpopress_pro_render_most_popular_section' ) ) :
  /**
   * Start most_popular section
   *
   * @return string most_popular content
   * @since Corpopress Pro 1.0.0
   *
   */
   function corpopress_pro_render_most_popular_section( $content_details = array() ) {
    $options = corpopress_pro_get_theme_options();

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="corpopress_pro_most_popular_section">

       <div id="magazine-most-popular" class="page-section">
                <div class="wrapper">
                <?php if( !empty( $options['most_popular_title'] ) ): ?>
                    <div class="section-header">
                        <h2 class="section-title"><?php echo esc_html( $options['most_popular_title'] ); ?></h2>
                    </div>
                <?php endif; ?>

                    <div class="col-2 clear">
                        <div class="hentry">

                        <?php $i=1; foreach ( $content_details as $content ): ?>

                        <?php if ( ( $i%2 ) == 0 ): ?>

                            <article>
                                <div class="magazine-post-wrapper">
                                    <div class="featured-image" style="background-image: url('<?php echo esc_url( $content['image'] ); ?>');">
                                        <a href="<?php echo esc_url( $content['url'] ); ?>" class="post-thumbnail-link"></a>
                                    </div>

                                    <div class="entry-container">
                                       <?php the_category( '', '', $content['id'] ); ?>

                                        <header class="entry-header">
                                            <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                        </header>   
                                    </div>
                                </div>
                            </article>

                        <?php endif; ?>

                            <?php $i++; endforeach; ?>
                        </div>

                        <div class="hentry">
                            <ul>

                            <?php $i=1; foreach ( $content_details as $content ): ?>

                        <?php if ( ( $i%2 ) !== 0 ): ?>
                               
                                <li>
                                    <div class="featured-image" style="background-image: url('<?php echo esc_url( $content['image'] ); ?>');">
                                        <a href="<?php echo esc_url( $content['url'] ); ?>" class="post-thumbnail-link"></a>
                                    </div>

                                    <div class="entry-container">
                                        <div class="entry-meta">
                                            <?php the_category( '', '', $content['id'] ); ?>
                                        </div>

                                        <header class="entry-header">
                                            <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                        </header>
                                    </div><!-- .entry-container -->
                                </li>

                                <?php endif; ?>

                            <?php $i++; endforeach; ?>

                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            </div>

    <?php }
endif;