<?php
/**
 * Most Viewed Posts section
 *
 * This is the template for the content of most_viewed section
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */
if ( ! function_exists( 'corpopress_pro_add_most_viewed_section' ) ) :
    /**
    * Add most_viewed section
    *
    *@since Corpopress Pro 1.0.0
    */
    function corpopress_pro_add_most_viewed_section() {
    	$options = corpopress_pro_get_theme_options();
        // Check if most_viewed is enabled on frontpage
        $most_viewed_enable = apply_filters( 'corpopress_pro_section_status', true, 'most_viewed_section_enable' );

        if ( true !== $most_viewed_enable ) {
            return false;
        }
        // Get most_viewed section details
        $section_details = array();
        $section_details = apply_filters( 'corpopress_pro_filter_most_viewed_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render most_viewed section now.
        corpopress_pro_render_most_viewed_section( $section_details );
    }
endif;

if ( ! function_exists( 'corpopress_pro_get_most_viewed_section_details' ) ) :
    /**
    * most_viewed section details.
    *
    * @since Corpopress Pro 1.0.0
    * @param array $input most_viewed section details.
    */
    function corpopress_pro_get_most_viewed_section_details( $input ) {
        $options = corpopress_pro_get_theme_options();

        // Content type.
        $most_viewed_content_type  = $options['most_viewed_content_type'];
        $most_viewed_count = ! empty( $options['most_viewed_count'] ) ? $options['most_viewed_count'] : 4;
        
        $content = array();
        switch ( $most_viewed_content_type ) {
        	
            case 'page':
                $page_ids = array();

                for ( $i = 1; $i <= $most_viewed_count; $i++ ) {
                    if ( ! empty( $options['most_viewed_content_page_' . $i] ) )
                        $page_ids[] = $options['most_viewed_content_page_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'page',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $most_viewed_count ),
                    'orderby'           => 'post__in',
                    );                    
            break;

            case 'post':
                $post_ids = array();

                for ( $i = 1; $i <= $most_viewed_count; $i++ ) {
                    if ( ! empty( $options['most_viewed_content_post_' . $i] ) )
                        $post_ids[] = $options['most_viewed_content_post_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'post',
                    'post__in'          => ( array ) $post_ids,
                    'posts_per_page'    => absint( $most_viewed_count ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'category':
                $cat_id = ! empty( $options['most_viewed_content_category'] ) ? $options['most_viewed_content_category'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $most_viewed_count ),
                    'cat'               => absint( $cat_id ),
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            default:
            break;
        }

        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['image']  	= has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'post-thumbnail' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';
                $page_post['author_id'] = get_post_field('post_author', get_the_ID());

                // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// most_viewed section content details.
add_filter( 'corpopress_pro_filter_most_viewed_section_details', 'corpopress_pro_get_most_viewed_section_details' );


if ( ! function_exists( 'corpopress_pro_render_most_viewed_section' ) ) :
  /**
   * Start most_viewed section
   *
   * @return string most_viewed content
   * @since Corpopress Pro 1.0.0
   *
   */
   function corpopress_pro_render_most_viewed_section( $content_details = array() ) {
        $options = corpopress_pro_get_theme_options();
        $title = ! empty( $options['most_viewed_title'] ) ? $options['most_viewed_title'] : '';

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="corpopress_pro_most_viewed_section">

        <div id="most-viewed-posts-section" class="grid-layout">
                <div class="wrapper">
                <?php if( !empty( $title ) ): ?>
                    <div class="section-header">
                        <h2 class="section-title"><?php echo esc_html( $title ); ?></h2>
                    </div><!-- .section-header -->

                <?php endif; ?>

                    <div class="section-content col-4 clear">
                        
                    <?php foreach ($content_details as $content ): ?>

                        <article>
                            <div class="featured-image" style="background-image: url('<?php echo esc_url( $content['image'] ); ?>');">
                                <a href="<?php echo esc_url( $content['url'] ); ?>" class="post-thumbnail-link"></a>
                            </div><!-- .featured-image -->

                            <div class="entry-container">
                                <div class="entry-meta">
                                    <?php corpopress_pro_posted_on( $content['id'] ); ?> 

                                    <span class="byline"> <?php echo esc_html__( 'By:', 'corpopress-pro' ); ?> <span class="author vcard"><a class="url fn n" href="<?php echo esc_url( get_author_posts_url( $content['author_id']) ); ?>" tabindex="0"><?php echo get_the_author_meta('display_name', $content['author_id']); ?></a></span></span>
                                </div><!-- .entry-meta -->

                                <header class="entry-header">
                                    <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                </header>
                            </div><!-- .entry-container -->
                        </article>
                        
                    <?php endforeach; ?>

                    </div><!-- .section-content -->
                </div>
            </div>

            </div>

    <?php }
endif;