<?php
/**
 * Politics section
 *
 * This is the template for the content of politics section
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */
if ( ! function_exists( 'corpopress_pro_add_politics_section' ) ) :
    /**
    * Add politics section
    *
    *@since Corpopress Pro 1.0.0
    */
    function corpopress_pro_add_politics_section() {
    	$options = corpopress_pro_get_theme_options();
        // Check if politics is enabled on frontpage
        $politics_enable = apply_filters( 'corpopress_pro_section_status', true, 'politics_section_enable' );

        if ( true !== $politics_enable ) {
            return false;
        }
        // Get politics section details
        $section_details = array();
        $section_details = apply_filters( 'corpopress_pro_filter_politics_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render politics section now.
        corpopress_pro_render_politics_section( $section_details );
    }
endif;

if ( ! function_exists( 'corpopress_pro_get_politics_section_details' ) ) :
    /**
    * politics section details.
    *
    * @since Corpopress Pro 1.0.0
    * @param array $input politics section details.
    */
    function corpopress_pro_get_politics_section_details( $input ) {
        $options = corpopress_pro_get_theme_options();

        // Content type.
        $politics_content_type  = $options['politics_content_type'];
        $politics_count = ! empty( $options['politics_count'] ) ? $options['politics_count'] : 5;
        
        $content = array();
        switch ( $politics_content_type ) {
        	
            case 'page':
                $page_ids = array();

                for ( $i = 1; $i <= $politics_count; $i++ ) {
                    if ( ! empty( $options['politics_content_page_' . $i] ) )
                        $page_ids[] = $options['politics_content_page_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'page',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $politics_count ),
                    'orderby'           => 'post__in',
                    );                    
            break;

            case 'post':
                $post_ids = array();

                for ( $i = 1; $i <= $politics_count; $i++ ) {
                    if ( ! empty( $options['politics_content_post_' . $i] ) )
                        $post_ids[] = $options['politics_content_post_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'post',
                    'post__in'          => ( array ) $post_ids,
                    'posts_per_page'    => absint( $politics_count ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'category':
                $cat_id = ! empty( $options['politics_content_category'] ) ? $options['politics_content_category'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $politics_count ),
                    'cat'               => absint( $cat_id ),
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            default:
            break;
        }


        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['image']  	= has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'post-thumbnail' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';

                // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// politics section content details.
add_filter( 'corpopress_pro_filter_politics_section_details', 'corpopress_pro_get_politics_section_details' );


if ( ! function_exists( 'corpopress_pro_render_politics_section' ) ) :
  /**
   * Start politics section
   *
   * @return string politics content
   * @since Corpopress Pro 1.0.0
   *
   */
   function corpopress_pro_render_politics_section( $content_details = array() ) {
    $options = corpopress_pro_get_theme_options();
        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="corpopress_pro_politics_section">

       <div id="magazine-poltics-posts" class="relative same-background">
                <div class="wrapper">

                <?php if( !empty( $options['politics_title'] ) ): ?>
                    <div class="section-header">
                        <h2 class="section-title"><?php echo esc_html( $options['politics_title'] ); ?></h2>
                    </div>
                <?php endif; ?>
                    <div class="col-3 grid clear">
                       
                    <?php foreach ($content_details as $content ): ?>
                        
                        <article class="grid-item">
                            <div class="highlighted-post-item">
                                <div class="featured-image">
                                    <img src="<?php echo esc_url( $content['image'] ); ?>">
                                </div><!-- .featured-image -->

                                <div class="entry-container">
                                    <?php the_category( '', '', $content['id'] ); ?>

                                    <header class="entry-header">
                                        <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                    </header>   
                                </div><!-- .entry-container -->
                            </div><!-- .highlighted-post-item -->
                        </article>

                    <?php endforeach; ?>
                       
                    </div><!-- .col-3 -->
                </div><!-- .wrapper -->
            </div>

            </div>

    <?php }
endif;