<?php
/**
 * popular_products section
 *
 * This is the template for the content of popular_products section
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */
if ( ! function_exists( 'corpopress_pro_add_popular_products_section' ) ) :
    /**
    * Add popular_products section
    *
    *@since Corpopress Pro 1.0.0
    */
    function corpopress_pro_add_popular_products_section() {
        $options = corpopress_pro_get_theme_options();
        // Check if popular_products is enabled on frontpage
        $popular_products_enable = apply_filters( 'corpopress_pro_section_status', true, 'popular_products_section_enable' );

        if ( ( true !== $popular_products_enable ) || ! class_exists( 'WooCommerce' ) ) {
            return false;
        }
        // Get popular_products section details
        $section_details = array();
        $section_details = apply_filters( 'corpopress_pro_filter_popular_products_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render popular_products section now.
        corpopress_pro_render_popular_products_section( $section_details );
    }
endif;

if ( ! function_exists( 'corpopress_pro_get_popular_products_section_details' ) ) :
    /**
    * popular_products section details.
    *
    * @since Corpopress Pro 1.0.0
    * @param array $input popular_products section details.
    */
    function corpopress_pro_get_popular_products_section_details( $input ) {
        $options = corpopress_pro_get_theme_options();

        // Content type.
        $popular_products_content_type  = $options['popular_products_content_type'];    
        $popular_products_count = !empty( $options['popular_products_count'] ) ? $options['popular_products_count'] : 4;
        
        $content = array();
        $content = array();
        switch ( $popular_products_content_type ) {

            case 'product':
                $page_ids = array();

                for ( $i = 1; $i <= $popular_products_count; $i++ ) {
                    if ( ! empty( $options['popular_products_content_product_' . $i] ) )
                        $page_ids[] = $options['popular_products_content_product_' . $i];
                }

                $args = array(
                    'post_type'         => 'product',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $popular_products_count ),
                    'orderby'           => 'post__in',
                    );
            break;
            case 'product-category':
                $cat_id = ! empty( $options['popular_products_content_product_category'] ) ? $options['popular_products_content_product_category'] : '';

                $args = array(
                'post_type'         => 'product',
                'posts_per_page'    => absint( $popular_products_count ),
                'tax_query'         => array(
                    array(
                        'taxonomy'  => 'product_cat',
                        'field'     => 'id',
                        'terms'     => $cat_id
                    )
                ) );
            break;

            default:
            break;
        }

        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'large' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';

                // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();

        
    
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// popular_products section content details.
add_filter( 'corpopress_pro_filter_popular_products_section_details', 'corpopress_pro_get_popular_products_section_details' );


if ( ! function_exists( 'corpopress_pro_render_popular_products_section' ) ) :
 
   function corpopress_pro_render_popular_products_section( $content_details = array() ) {
        $options = corpopress_pro_get_theme_options();

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="corpopress_pro_popular_products_section" class="relative page-section same-background">
       
        <div id="popular-products">
                <div class="wrapper">
                    <div class="section-header">
                    <?php if( !empty( $options['popular_products_title'] ) ): ?>
                        <h2 class="section-title"><?php echo esc_html( $options['popular_products_title'] ); ?></h2>
                    <?php endif;

                            if( !empty( $options['popular_products_sub_title'] ) ):
                     ?>
                        <p class="section-subtitle"><?php echo esc_html( $options['popular_products_sub_title'] ); ?></p>
                    <?php endif; ?>
                    </div><!-- .section-header -->

                    <div class="section-content">
                        <ul class="products product-slider" data-slick='{"slidesToShow": 4, "slidesToScroll": 1, "infinite": false, "speed": 1500, "dots": false, "arrows": false, "autoplay": false, "draggable": true, "fade": false }'>
                            
                        <?php foreach ($content_details as $content ): 

                        $image = $content['image'] == '' ? get_template_directory_uri().'/assets/uploads/no-featured-image-590x650.jpg' : $content['image'] ;
                        
                        ?>
                            
                            <li class="product featured-products">
                                <a href="<?php echo esc_url( $content['url'] ) ; ?>" class="woocommerce-LoopProduct-link woocommerce-loop-product__link">
                                    <?php 
                                    $product = new WC_Product( $content['id'] );
                                    if ( $product->get_sale_price() ): 
                                        ?>
                                    <span class="onsale">
                                        <?php esc_html_e('Sale!', 'corpopress-pro'); ?>
                                    </span>
                                <?php endif; ?>
                                    <img width="330" height="400" src="<?php echo esc_url($image); ?>">
                                    <div class="product_meta">
                                         <?php 
                            $terms = get_the_terms ( $content['id'], 'product_cat' );
                            foreach ( $terms as $term ) { ?>
                            <span class="posted_in">
                                <a href="<?php echo esc_url( get_term_link( $term->term_id, 'product_cat' ) ) ?>"><?php echo esc_html( $term->name) ; ?></a>
                            </span><!-- .posted_in -->

                            <?php }
                            ?>
                                    </div><!-- .product-meta -->
                                    <h2 class="woocommerce-loop-product__title"><?php echo esc_html( $content['title'] ); ?></h2>
                                    <span class="price">
                                        <?php 
                            $product = new WC_Product( $content['id'] );
                            echo $product->get_price_html();
                            ?>
                                    </span>
                                </a>
                                <a href="<?php echo do_shortcode( '[add_to_cart_url id="' . absint( $content['id'] ) . '"]' ); ?>" class="button product_type_simple add_to_cart_button ajax_add_to_cart"><?php esc_html_e('Add to cart', 'corpopress-pro'); ?></a>
                            </li>

                        <?php endforeach; ?>
                            
                        </ul><!-- .product-slider -->
                    </div><!-- .section-content -->
                </div><!-- .wrapper -->
            </div>

            </div>
       
    <?php }
endif;