<?php
/**
 * Promotion section
 *
 * This is the template for the content of promotion section
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */
if ( ! function_exists( 'corpopress_pro_add_promotion_section' ) ) :
    /**
    * Add promotion section
    *
    *@since Corpopress Pro 1.0.0
    */
    function corpopress_pro_add_promotion_section() {
    	$options = corpopress_pro_get_theme_options();
        // Check if promotion is enabled on frontpage
        $promotion_enable = apply_filters( 'corpopress_pro_section_status', true, 'promotion_section_enable' );

        if ( true !== $promotion_enable ) {
            return false;
        }
        // Get promotion section details
        $section_details = array();
        $section_details = apply_filters( 'corpopress_pro_filter_promotion_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render promotion section now.
        corpopress_pro_render_promotion_section( $section_details );
    }
endif;

if ( ! function_exists( 'corpopress_pro_get_promotion_section_details' ) ) :
    /**
    * promotion section details.
    *
    * @since Corpopress Pro 1.0.0
    * @param array $input promotion section details.
    */
    function corpopress_pro_get_promotion_section_details( $input ) {
        $options = corpopress_pro_get_theme_options();

        // Content type.
        $promotion_content_type  = $options['promotion_content_type'];
        
        $content = array();
        switch ( $promotion_content_type ) {
        	
            case 'custom':
                $custom['title']        = ! empty( $options['promotion_title'] ) ? $options['promotion_title'] : '';
                $custom['excerpt']      = ! empty( $options['promotion_description'] ) ? $options['promotion_description'] : '';
                $custom['image']        = ! empty( $options['promotion_image'] ) ? $options['promotion_image'] : '';
                $custom['url']          = ! empty( $options['promotion_btn_link'] ) ? $options['promotion_btn_link'] : '';

                // Push to the main array.
                array_push( $content, $custom );
            break;

            case 'page':
                $page_id = ! empty( $options['promotion_content_page'] ) ? $options['promotion_content_page'] : '';
                $args = array(
                    'post_type'         => 'page',
                    'page_id'           => $page_id,
                    'posts_per_page'    => 1,
                    );                    
            break;

            case 'post':
                $post_id = ! empty( $options['promotion_content_post'] ) ? $options['promotion_content_post'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'p'                 => $post_id,
                    'posts_per_page'    => 1,
                    'ignore_sticky_posts' => true,
                    );
            break;

            default:
            break;
        }

        if ( 'custom' !== $promotion_content_type ) :
            // Run The Loop.
            $query = new WP_Query( $args );
            if ( $query->have_posts() ) : 
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['title']     = get_the_title();
                    $page_post['url']       = get_the_permalink();
                    $page_post['excerpt']   = corpopress_pro_trim_content( 30 );
                    $page_post['image']  	= has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'large' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';

                    // Push to the main array.
                    array_push( $content, $page_post );
                endwhile;
            endif;
            wp_reset_postdata();
        endif;
            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// promotion section content details.
add_filter( 'corpopress_pro_filter_promotion_section_details', 'corpopress_pro_get_promotion_section_details' );


if ( ! function_exists( 'corpopress_pro_render_promotion_section' ) ) :
  /**
   * Start promotion section
   *
   * @return string promotion content
   * @since Corpopress Pro 1.0.0
   *
   */
   function corpopress_pro_render_promotion_section( $content_details = array() ) {
        $options = corpopress_pro_get_theme_options();
        $readmore = ! empty( $options['promotion_btn_title'] ) ? $options['promotion_btn_title'] : esc_html__( 'Try it Free', 'corpopress-pro' );

        if ( empty( $content_details ) ) {
            return;
        } 

        foreach ( $content_details as $content ) : ?>

        <div id="corpopress_pro_promotion_section">

            <div id="latest">
                <div class="wrapper">
                    <article>
                        <?php if ( ! empty( $content['image'] ) ) : ?>
                            <div class="featured-image" style="background-image: url('<?php echo esc_url( $content['image'] ); ?>');">  
                            </div><!-- .featured-image -->
                        <?php endif; ?>

                        <div class="entry-container">
                            <?php if ( ! empty( $content['title'] ) ) : ?>
                                <div class="section-header">
                                    <h2 class="section-title"><?php echo esc_html( $content['title'] ); ?></h2>
                                </div>
                            <?php endif; ?>

                            <div class="section-content">
                                <?php if ( ! empty( $content['excerpt'] ) ) : ?>
                                    <div class="entry-content">
                                        <p><?php echo wp_kses_post( $content['excerpt'] ); ?></p>
                                    </div><!-- .entry-content -->
                                <?php endif; ?>

                                <div class="buttons">
                                    <?php if ( ! empty( $content['url'] ) ) : ?>
                                        <a href="<?php echo esc_url( $content['url'] ); ?>" class="btn btn-default"><?php echo esc_html( $readmore ); ?></a>
                                    <?php endif; 

                                    if ( ! empty( $options['promotion_alt_btn_title'] ) && ! empty( $options['promotion_alt_btn_url'] ) ) : ?>
                                        <a href="<?php echo esc_url( $options['promotion_alt_btn_url'] ); ?>" class="btn btn-transparent"><?php echo esc_html( $options['promotion_alt_btn_title'] ); ?></a>
                                    <?php endif; ?>
                                </div>
                            </div><!-- .section-content -->
                        </div><!-- .entry-container -->

                    </article><!-- article -->
                </div><!-- .wrapper -->
            </div><!-- #latest -->

            </div>

        <?php endforeach;
    }
endif;