<?php
/**
 * Recent Posts section
 *
 * This is the template for the content of recent section
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */
if ( ! function_exists( 'corpopress_pro_add_recent_section' ) ) :
    /**
    * Add recent section
    *
    *@since Corpopress Pro 1.0.0
    */
    function corpopress_pro_add_recent_section() {
    	$options = corpopress_pro_get_theme_options();
        // Check if recent is enabled on frontpage
        $recent_enable = apply_filters( 'corpopress_pro_section_status', true, 'recent_section_enable' );

        if ( true !== $recent_enable ) {
            return false;
        }
        // Get recent section details
        $section_details = array();
        $section_details = apply_filters( 'corpopress_pro_filter_recent_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render recent section now.
        corpopress_pro_render_recent_section( $section_details );
    }
endif;

if ( ! function_exists( 'corpopress_pro_get_recent_section_details' ) ) :
    /**
    * recent section details.
    *
    * @since Corpopress Pro 1.0.0
    * @param array $input recent section details.
    */
    function corpopress_pro_get_recent_section_details( $input ) {
        $options = corpopress_pro_get_theme_options();

        // Content type.
        $recent_content_type  = $options['recent_content_type'];
        $recent_count = ! empty( $options['recent_count'] ) ? $options['recent_count'] : 3;
        
        $content = array();
        switch ( $recent_content_type ) {
        	
            case 'page':
                $page_ids = array();

                for ( $i = 1; $i <= $recent_count; $i++ ) {
                    if ( ! empty( $options['recent_content_page_' . $i] ) )
                        $page_ids[] = $options['recent_content_page_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'page',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $recent_count ),
                    'orderby'           => 'post__in',
                    );                    
            break;

            case 'post':
                $post_ids = array();

                for ( $i = 1; $i <= $recent_count; $i++ ) {
                    if ( ! empty( $options['recent_content_post_' . $i] ) )
                        $post_ids[] = $options['recent_content_post_' . $i];
                }
                
                $args = array(
                    'post_type'         => 'post',
                    'post__in'          => ( array ) $post_ids,
                    'posts_per_page'    => absint( $recent_count ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'category':
                $cat_id = ! empty( $options['recent_content_category'] ) ? $options['recent_content_category'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $recent_count ),
                    'cat'               => absint( $cat_id ),
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            default:
            break;
        }


        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['excerpt']   = corpopress_pro_trim_content( $options['recent_excerpt'] );
                $page_post['image']  	= has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'post-thumbnail' ) : '';
                $page_post['author_id'] = get_post_field('post_author', get_the_ID());

                // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// recent section content details.
add_filter( 'corpopress_pro_filter_recent_section_details', 'corpopress_pro_get_recent_section_details' );


if ( ! function_exists( 'corpopress_pro_render_recent_section' ) ) :
  /**
   * Start recent section
   *
   * @return string recent content
   * @since Corpopress Pro 1.0.0
   *
   */
   function corpopress_pro_render_recent_section( $content_details = array() ) {
        $options = corpopress_pro_get_theme_options();
        $column = ! empty( $options['recent_column'] ) ? $options['recent_column'] : 'col-3';
        $title = ! empty( $options['recent_title'] ) ? $options['recent_title'] : '';

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="corpopress_pro_recent_section">

        <div id="recent-posts-section" class="relative page-section same-background">
                <div class="wrapper">
                <?php if( !empty( $title ) ): ?>
                    
                    <div class="section-header">
                        <h2 class="section-title"><?php echo esc_html( $title ); ?></h2>
                    </div><!-- .section-header -->

                <?php endif; ?>

                    <div class="section-content <?php echo esc_attr( $column ); ?> clear">
                        
                    <?php foreach ($content_details as $content ): ?>

                        <article>
                            <div class="post-wrapper">
                                <div class="featured-image">
                                    <a href="<?php echo esc_url( $content['url'] ); ?>"><img src="<?php echo esc_url( $content['image'] ); ?>" alt="blog"></a>
                                </div><!-- .featured-image -->

                                <div class="entry-container">
                                    <div class="entry-meta">
                                        <span class="cat-links">
                                            <ul class="post-categories">
                                                <?php the_category( '', '', $content['id'] ); ?>
                                            </ul>
                                        </span><!-- .cat-links -->
                                    </div><!-- .entry-meta -->

                                    <header class="entry-header">
                                        <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                    </header>

                                    <div class="entry-content">
                                        <p><?php echo esc_html( $content['excerpt'] ); ?></p>
                                    </div><!-- .entry-content -->

                                    <div class="post-footer-meta">

                                    <?php if( $options['recent_author_enable'] == true ){ ?>

                                        <span class="byline"><?php echo esc_html__( 'By:', 'corpopress-pro' ); ?>
                                            <span class="author vcard"><a class="url fn n" href="<?php echo esc_url( get_author_posts_url( $content['author_id']) ); ?>"><?php echo get_the_author_meta('display_name', $content['author_id']); ?></a></span>
                                        </span>

                                        <?php } ?>

                                       <?php corpopress_pro_posted_on( $content['id'] ); ?> 
                                    </div><!-- .entry-meta -->
                                </div><!-- .entry-container -->
                            </div><!-- .post-wrapper -->
                        </article>
                        
                    <?php endforeach; ?>

                    </div><!-- .section-content -->
                </div><!-- .wrapper -->
            </div><!-- #recent-posts-section -->

        </div>

    <?php }
endif;