<?php
/**
 * Service section
 *
 * This is the template for the content of service section
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */
if ( ! function_exists( 'corpopress_pro_add_service_section' ) ) :
    /**
    * Add service section
    *
    *@since Corpopress Pro 1.0.0
    */
    function corpopress_pro_add_service_section() {
    	$options = corpopress_pro_get_theme_options();
        // Check if service is enabled on frontpage
        $service_enable = apply_filters( 'corpopress_pro_section_status', true, 'service_section_enable' );

        if ( true !== $service_enable ) {
            return false;
        }
        // Get service section details
        $section_details = array();
        $section_details = apply_filters( 'corpopress_pro_filter_service_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render service section now.
        corpopress_pro_render_service_section( $section_details );
    }
endif;

if ( ! function_exists( 'corpopress_pro_get_service_section_details' ) ) :
    /**
    * service section details.
    *
    * @since Corpopress Pro 1.0.0
    * @param array $input service section details.
    */
    function corpopress_pro_get_service_section_details( $input ) {
        $options = corpopress_pro_get_theme_options();

        // Content type.
        $service_content_type  = $options['service_content_type'];
        $service_count = ! empty( $options['service_count'] ) ? $options['service_count'] : 4;
        
        $content = array();
        switch ( $service_content_type ) {
        	
            case 'page':
                $page_ids = array();
                $icons = array();

                for ( $i = 1; $i <= $service_count; $i++ ) {
                    if ( ! empty( $options['service_content_page_' . $i] ) ) :
                        $page_ids[] = $options['service_content_page_' . $i];
                        $icons[] = ! empty( $options['service_content_icon_' . $i] ) ? $options['service_content_icon_' . $i] : 'fa-cogs';
                    endif;
                }
                
                $args = array(
                    'post_type'         => 'page',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $service_count ),
                    'orderby'           => 'post__in',
                    );                    
            break;

            case 'post':
                $post_ids = array();
                $icons = array();

                for ( $i = 1; $i <= $service_count; $i++ ) {
                    if ( ! empty( $options['service_content_post_' . $i] ) ) :
                        $post_ids[] = $options['service_content_post_' . $i];
                        $icons[] = ! empty( $options['service_content_icon_' . $i] ) ? $options['service_content_icon_' . $i] : 'fa-cogs';
                    endif;
                }
                
                $args = array(
                    'post_type'         => 'post',
                    'post__in'          => ( array ) $post_ids,
                    'posts_per_page'    => absint( $service_count ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'category':
                $cat_id = ! empty( $options['service_content_category'] ) ? $options['service_content_category'] : '';
                $icons = array();
                
                for ( $i = 1; $i <= $service_count; $i++ ) {
                    $icons[] = ! empty( $options['service_content_icon_' . $i] ) ? $options['service_content_icon_' . $i] : 'fa-cogs';
                }

                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $service_count ),
                    'cat'               => absint( $cat_id ),
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            default:
            break;
        }


            // Run The Loop.
            $query = new WP_Query( $args );
            if ( $query->have_posts() ) : 
                $i = 0;
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['title']     = get_the_title();
                    $page_post['url']       = get_the_permalink();
                    $page_post['icon']      = ! empty( $icons[ $i ] ) ? $icons[ $i ] : 'fa-cogs';
                    $page_post['excerpt']   = corpopress_pro_trim_content( 13 );

                    // Push to the main array.
                    array_push( $content, $page_post );
                    $i++;
                endwhile;
            endif;
            wp_reset_postdata();

            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// service section content details.
add_filter( 'corpopress_pro_filter_service_section_details', 'corpopress_pro_get_service_section_details' );


if ( ! function_exists( 'corpopress_pro_render_service_section' ) ) :
  /**
   * Start service section
   *
   * @return string service content
   * @since Corpopress Pro 1.0.0
   *
   */
   function corpopress_pro_render_service_section( $content_details = array() ) {
        $options = corpopress_pro_get_theme_options();
        $column = ! empty( $options['service_column'] ) ? $options['service_column'] : 'col-4';
        $i = 1;        

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="corpopress_pro_service_section">

        <div id="services" class="page-section <?php echo esc_attr( $column ); ?>">
            <div class="wrapper">
                <div class="section-wrapper align-center">
                    <?php if ( ! empty( $options['service_title'] ) ) : ?>
                        <div class="section-header">
                            <h2 class="section-title"><?php echo esc_html( $options['service_title'] ); ?></h2>
                        </div><!-- .section-header -->
                    <?php endif; ?>
                </div><!-- .section-wrapper -->

                <?php foreach ( $content_details as $content ) : ?>
                    <article class="hentry">
                        <div class="icon-container">
                            <a href="<?php echo esc_url( $content['url'] ) ?>">
                                <i class="fa <?php echo esc_attr( $content['icon'] ); ?>"></i>
                            </a>
                        </div><!-- .icon-container -->

                        <header class="entry-header">
                            <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                        </header><!-- .entry-header -->
                        <div class="entry-content">
                           <?php echo esc_html( $content['excerpt'] ); ?>
                        </div><!-- .entry-content -->
                    </article><!-- .article -->
                <?php endforeach; ?>

            </div><!-- .wrapper -->
        </div><!-- #services -->

        </div>
        
    <?php }
endif;