<?php
/**
 * Sponsor section
 *
 * This is the template for the content of sponsor section
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */
if ( ! function_exists( 'corpopress_pro_add_sponsor_section' ) ) :
    /**
    * Add sponsor section
    *
    *@since Corpopress Pro 1.0.0
    */
    function corpopress_pro_add_sponsor_section() {
        $options = corpopress_pro_get_theme_options();
        // Check if sponsor is enabled on frontpage
        $sponsor_enable = apply_filters( 'corpopress_pro_section_status', true, 'sponsor_section_enable' );

        if ( true !== $sponsor_enable ) {
            return false;
        }
        // Get sponsor section details
        $section_details = array();
        $section_details = apply_filters( 'corpopress_pro_filter_sponsor_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render sponsor section now.
        corpopress_pro_render_sponsor_section( $section_details );
    }
endif;

if ( ! function_exists( 'corpopress_pro_get_sponsor_section_details' ) ) :
    /**
    * sponsor section details.
    *
    * @since Corpopress Pro 1.0.0
    * @param array $input sponsor section details.
    */
    function corpopress_pro_get_sponsor_section_details( $input ) {
        $options = corpopress_pro_get_theme_options();

        // Content type.
        $sponsor_content_type  = $options['sponsor_content_type'];
        
        $content = array();
        switch ( $sponsor_content_type ) {

            case 'custom':
                $custom['title']        = ! empty( $options['sponsor_title'] ) ? $options['sponsor_title'] : '';
                $custom['excerpt']        = ! empty( $options['sponsor_description'] ) ? $options['sponsor_description'] : '';
                $custom['url']          = ! empty( $options['sponsor_btn_link'] ) ? $options['sponsor_btn_link'] : '';

                // Push to the main array.
                array_push( $content, $custom );
            break;
            
            case 'page':
                $page_id = ! empty( $options['sponsor_content_page'] ) ? $options['sponsor_content_page'] : '';
                $args = array(
                    'post_type'         => 'page',
                    'page_id'           => $page_id,
                    'posts_per_page'    => 1,
                    );                    
            break;

            case 'post':
                $post_id = ! empty( $options['sponsor_content_post'] ) ? $options['sponsor_content_post'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'p'                 => $post_id,
                    'posts_per_page'    => 1,
                    );
            break;

            default:
            break;
        }

        if ( 'custom' !== $sponsor_content_type ) :

            // Run The Loop.
            $query = new WP_Query( $args );
            if ( $query->have_posts() ) : 
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['id']        = get_the_id();
                    $page_post['title']     = get_the_title();
                    $page_post['excerpt']   = corpopress_pro_trim_content( $options['sponsor_excerpt_length'] );
                    $page_post['url']       = get_the_permalink();

                    // Push to the main array.
                    array_push( $content, $page_post );
                endwhile;
            endif;
            wp_reset_postdata();

            endif;

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// sponsor section content details.
add_filter( 'corpopress_pro_filter_sponsor_section_details', 'corpopress_pro_get_sponsor_section_details' );


if ( ! function_exists( 'corpopress_pro_render_sponsor_section' ) ) :
  /**
   * Start sponsor section
   *
   * @return string sponsor content
   * @since Corpopress Pro 1.0.0
   *
   */
   function corpopress_pro_render_sponsor_section( $content_details = array() ) {
        $options = corpopress_pro_get_theme_options();
        $sponsor_btn_title = ! empty( $options['sponsor_btn_title'] ) ? $options['sponsor_btn_title'] : '';
        $sponsor_bg_image = !empty( $options['sponsor_bg_image'] ) ? $options['sponsor_bg_image'] : '';
        if ( empty( $content_details ) ) {
            return;
        } 
        ?>
        <?php foreach ( $content_details as $content ) : ?>
        
        <div id="corpopress_pro_sponsor_section">

        <div id="sponsor-section" class="relative page-section" style="background-image: url('<?php echo esc_url( $sponsor_bg_image ); ?>');">
                <div class="overlay"></div>
                <div class="wrapper">
                    <header class="entry-header">
                        <h2 class="entry-title"><?php echo esc_html( $content['title'] ); ?></h2>
                    </header>

                    <div class="entry-content">
                        <p><?php echo esc_html( $content['excerpt'] ); ?></p>
                    </div><!-- .entry-content -->

                    <?php if( !empty( $sponsor_btn_title ) ): ?>
                    <div class="read-more">
                        <a href="<?php echo esc_url( $content['url'] ); ?>" class="btn"><?php echo esc_html( $sponsor_btn_title ); ?></a>
                    </div>
                <?php endif; ?>
                </div><!-- .wrapper -->
            </div>            

        </div>

    <?php 
    endforeach;
}
endif;