<?php
/**
 * Team section
 *
 * This is the template for the content of team section
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */
if ( ! function_exists( 'corpopress_pro_add_team_section' ) ) :
    /**
    * Add team section
    *
    *@since Corpopress Pro 1.0.0
    */
    function corpopress_pro_add_team_section() {
    	$options = corpopress_pro_get_theme_options();
        // Check if team is enabled on frontpage
        $team_enable = apply_filters( 'corpopress_pro_section_status', true, 'team_section_enable' );

        if ( true !== $team_enable ) {
            return false;
        }
        // Get team section details
        $section_details = array();
        $section_details = apply_filters( 'corpopress_pro_filter_team_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render team section now.
        corpopress_pro_render_team_section( $section_details );
    }
endif;

if ( ! function_exists( 'corpopress_pro_get_team_section_details' ) ) :
    /**
    * team section details.
    *
    * @since Corpopress Pro 1.0.0
    * @param array $input team section details.
    */
    function corpopress_pro_get_team_section_details( $input ) {
        $options = corpopress_pro_get_theme_options();

        // Content type.
        $team_content_type  = $options['team_content_type'];
        
        $content = array();
        switch ( $team_content_type ) {
        	
            case 'page':
                $page_ids = array();
                $position = array();

                for ( $i = 1; $i <= 4; $i++ ) {
                    if ( ! empty( $options['team_content_page_' . $i] ) ) :
                        $page_ids[] = $options['team_content_page_' . $i];
                        $position[] = ! empty( $options['team_position_' . $i] ) ? $options['team_position_' . $i] : '';
                        $social[]   = ! empty( $options['team_social_' . $i] ) ? $options['team_social_' . $i] : '';
                    endif;
                }
                
                $args = array(
                    'post_type'         => 'page',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => 4,
                    'orderby'           => 'post__in',
                    );                    
            break;

            case 'post':
                $post_ids = array();
                $position = array();

                for ( $i = 1; $i <= 4; $i++ ) {
                    if ( ! empty( $options['team_content_post_' . $i] ) ) :
                        $post_ids[] = $options['team_content_post_' . $i];
                        $position[] = ! empty( $options['team_position_' . $i] ) ? $options['team_position_' . $i] : '';
                        $social[]   = ! empty( $options['team_social_' . $i] ) ? $options['team_social_' . $i] : '';
                    endif;
                }
                
                $args = array(
                    'post_type'         => 'post',
                    'post__in'          => ( array ) $post_ids,
                    'posts_per_page'    => 4,
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'category':
                $cat_id = ! empty( $options['team_content_category'] ) ? $options['team_content_category'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => 4,
                    'cat'               => absint( $cat_id ),
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'custom':
                for ( $i = 1; $i <= 4; $i++ ) {
                    if ( ! empty( $options['team_title_' . $i] ) ) :
                        $custom['title']        = $options['team_title_' . $i];
                        $custom['image']        = ! empty( $options['team_image_' . $i] ) ? $options['team_image_' . $i] : '';
                        $custom['url']          = ! empty( $options['team_link_' . $i] ) ? $options['team_link_' . $i] : '';
                        $custom['position']     = ! empty( $options['team_position_' . $i] ) ? $options['team_position_' . $i] : '';
                        $custom['social']     = ! empty( $options['team_social_' . $i] ) ? $options['team_social_' . $i] : '';
                        
                        // Push to the main array.
                        array_push( $content, $custom );

                    endif;


                    
                }
            break;


            default:
            break;
        }

        if ( 'custom' !== $team_content_type ) {
            // Run The Loop.
            $query = new WP_Query( $args );
            $i = 0;
            if ( $query->have_posts() ) : 
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['title']     = get_the_title();
                    $page_post['position']  = ( 'category' !== $team_content_type && ! empty( $position[$i] ) ) ? $position[$i] : '';
                    $page_post['social']    = ( 'category' !== $team_content_type && ! empty( $social[$i] ) ) ? $social[$i] : '';
                    $page_post['url']       = get_the_permalink();
                    $page_post['image']  	= has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'post-thumbnail' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';

                    // Push to the main array.
                    array_push( $content, $page_post );
                    $i++;
                endwhile;
            endif;
            wp_reset_postdata();
        }
            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// team section content details.
add_filter( 'corpopress_pro_filter_team_section_details', 'corpopress_pro_get_team_section_details' );


if ( ! function_exists( 'corpopress_pro_render_team_section' ) ) :
  /**
   * Start team section
   *
   * @return string team content
   * @since Corpopress Pro 1.0.0
   *
   */
   function corpopress_pro_render_team_section( $content_details = array() ) {
        $options = corpopress_pro_get_theme_options();
        $i = 1;

        if ( empty( $content_details ) ) {
            return;
        } ?>

         <div id="corpopress_pro_team_section">

        <div id="team" class="page-section no-padding-bottom col-<?php echo count( $content_details ); ?>">
            <div class="wrapper">
                <div class="team-wrapper clear">
                    <?php if ( ! empty( $options['team_title'] ) ) : ?>
                        <div class="section-header clear">
                            <h2 class="section-title"><?php echo esc_html( $options['team_title'] ); ?></h2>
                        </div>
                    <?php endif;

                    if ( ! empty( $options['team_btn_title'] ) && ! empty( $options['team_btn_url'] ) ) : ?>
                        <a href="<?php echo esc_url( $options['team_btn_url'] ); ?>" class="btn btn-default"><?php echo esc_html( $options['team_btn_title'] ); ?></a>
                    <?php endif; ?>
                </div><!-- .team-wrapper -->

                <div class="section-content">
                    <?php foreach ( $content_details as $content ) : ?>
                        <article class="hentry">
                            <?php if ( ! empty( $content['image'] ) ) : ?>
                                <div class="featured-image">
                                    <img src="<?php echo esc_url( $content['image'] ); ?>" alt="<?php echo esc_attr( $content['title'] ); ?>">
                                    <div class="overlay"></div>
                                    <div class="icon-content">
                                        <?php echo corpopress_pro_get_svg( array( 'icon' => 'circle-plus' ) ); ?>
                                    </div><!-- .icon-content -->
                                </div><!-- .featured-image -->
                            <?php endif; ?>

                            <div class="team-content">
                                <?php if ( ! empty( $content['title'] ) || ! empty( $content['position'] ) ) : ?>
                                    <header class="entry-header">
                                        <?php if ( ! empty( $content['title'] ) ) : ?>
                                            <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                        <?php endif; 

                                        if ( ! empty( $content['position'] ) ) : ?>
                                            <span class="position"><?php echo esc_html( $content['position'] ); ?></span>
                                        <?php endif; ?>
                                    </header>
                                <?php endif;

                                if ( ! empty( $content['social'] ) ) : 
                                    $social = explode( '|', $content['social'] ); ?>
                                    <ul class="social-icons">
                                        <?php foreach( $social as $social_link ) : ?>
                                            <li>
                                                <a href="<?php echo esc_url( $social_link ); ?>">
                                                    <?php echo corpopress_pro_return_social_icon( $social_link ); ?>
                                                </a>
                                            </li>
                                        <?php endforeach; ?>
                                    </ul>
                                <?php endif; ?>
                            </div><!-- .team-content -->
                        </article><!-- .hentry -->
                    <?php $i++; 
                    endforeach; ?>

                </div><!-- .section-content -->
            </div><!-- .wrapper -->
        </div><!-- #team -->

        </div>

    <?php }
endif;