<?php
/**
 * Testimonial section
 *
 * This is the template for the content of testimonial section
 *
 * @package Theme Palace
 * @subpackage Corpopress Pro
 * @since Corpopress Pro 1.0.0
 */
if ( ! function_exists( 'corpopress_pro_add_testimonial_section' ) ) :
    /**
    * Add testimonial section
    *
    *@since Corpopress Pro 1.0.0
    */
    function corpopress_pro_add_testimonial_section() {
    	$options = corpopress_pro_get_theme_options();
        // Check if testimonial is enabled on frontpage
        $testimonial_enable = apply_filters( 'corpopress_pro_section_status', true, 'testimonial_section_enable' );

        if ( true !== $testimonial_enable ) {
            return false;
        }
        // Get testimonial section details
        $section_details = array();
        $section_details = apply_filters( 'corpopress_pro_filter_testimonial_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render testimonial section now.
        corpopress_pro_render_testimonial_section( $section_details );
    }
endif;

if ( ! function_exists( 'corpopress_pro_get_testimonial_section_details' ) ) :
    /**
    * testimonial section details.
    *
    * @since Corpopress Pro 1.0.0
    * @param array $input testimonial section details.
    */
    function corpopress_pro_get_testimonial_section_details( $input ) {
        $options = corpopress_pro_get_theme_options();

        // Content type.
        $testimonial_content_type  = $options['testimonial_content_type'];
        $testimonial_count = ! empty( $options['testimonial_count'] ) ? $options['testimonial_count'] : 3;
        
        $content = array();
        switch ( $testimonial_content_type ) {
        	
            case 'page':
                $page_ids = array();
                $position = array();

                for ( $i = 1; $i <= $testimonial_count; $i++ ) {
                    if ( ! empty( $options['testimonial_content_page_' . $i] ) ) :
                        $page_ids[] = $options['testimonial_content_page_' . $i];
                        $position[] = ! empty( $options['testimonial_position_' . $i] ) ? $options['testimonial_position_' . $i] : '';
                    endif;
                }
                
                $args = array(
                    'post_type'         => 'page',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $testimonial_count ),
                    'orderby'           => 'post__in',
                    );                    
            break;

            case 'post':
                $post_ids = array();
                $position = array();

                for ( $i = 1; $i <= $testimonial_count; $i++ ) {
                    if ( ! empty( $options['testimonial_content_post_' . $i] ) ) :
                        $post_ids[] = $options['testimonial_content_post_' . $i];
                        $position[] = ! empty( $options['testimonial_position_' . $i] ) ? $options['testimonial_position_' . $i] : '';
                    endif;
                }
                
                $args = array(
                    'post_type'         => 'post',
                    'post__in'          => ( array ) $post_ids,
                    'posts_per_page'    => absint( $testimonial_count ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'category':
                $cat_id = ! empty( $options['testimonial_content_category'] ) ? $options['testimonial_content_category'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $testimonial_count ),
                    'cat'               => absint( $cat_id ),
                    'ignore_sticky_posts'   => true,
                    );                    
            break;

            case 'custom':
                for ( $i = 1; $i <= $testimonial_count; $i++ ) {
                    $custom['title']        = ! empty( $options['testimonial_title_' . $i] ) ? $options['testimonial_title_' . $i] : '';
                    $custom['excerpt']      = ! empty( $options['testimonial_description_' . $i] ) ? $options['testimonial_description_' . $i] : '';
                    $custom['image']        = ! empty( $options['testimonial_image_' . $i] ) ? $options['testimonial_image_' . $i] : '';
                    $custom['url']          = ! empty( $options['testimonial_link_' . $i] ) ? $options['testimonial_link_' . $i] : '';
                    $custom['position']     = ! empty( $options['testimonial_position_' . $i] ) ? $options['testimonial_position_' . $i] : '';


                    // Push to the main array.
                    array_push( $content, $custom );
                }
            break;


            default:
            break;
        }

        if ( 'custom' !== $testimonial_content_type ) {
            // Run The Loop.
            $query = new WP_Query( $args );
            $i = 0;
            if ( $query->have_posts() ) : 
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['title']     = get_the_title();
                    $page_post['position']  = ( 'category' !== $testimonial_content_type && ! empty( $position[$i] ) ) ? $position[$i] : '';
                    $page_post['url']       = get_the_permalink();
                    $page_post['excerpt']   = corpopress_pro_trim_content( 20 );
                    $page_post['image']  	= has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'thumbnail' ) : get_template_directory_uri().'/assets/uploads/no-featured-image-150x150.jpg';

                    // Push to the main array.
                    array_push( $content, $page_post );
                    $i++;
                endwhile;
            endif;
            wp_reset_postdata();
        }
            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// testimonial section content details.
add_filter( 'corpopress_pro_filter_testimonial_section_details', 'corpopress_pro_get_testimonial_section_details' );


if ( ! function_exists( 'corpopress_pro_render_testimonial_section' ) ) :
  /**
   * Start testimonial section
   *
   * @return string testimonial content
   * @since Corpopress Pro 1.0.0
   *
   */
   function corpopress_pro_render_testimonial_section( $content_details = array() ) {
        $options = corpopress_pro_get_theme_options();
        $column = ! empty( $options['testimonial_column'] ) ? $options['testimonial_column'] : 'col-4';

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="corpopress_pro_testimonial_section">

        <div id="testimonial" class="page-section <?php echo esc_attr( $column ); ?>">
            <div class="wrapper">
                <?php if ( ! empty( $options['testimonial_title'] ) ) : ?>
                    <div class="section-header">
                        <h2 class="section-title"><?php echo esc_html( $options['testimonial_title'] ); ?></h2>
                    </div>
                <?php endif; ?>
                <div class="section-content">
                    <?php foreach ( $content_details as $content ) : ?>
                        <article class="hentry">
                            <div class="testimonial-item-wrapper">

                                <?php if ( ! empty( $content['excerpt'] ) ) : ?>
                                    <div class="entry-content">
                                        <p><?php echo wp_kses_post( $content['excerpt'] ); ?></p>
                                    </div><!-- .entry-content -->
                                <?php endif;

                                if ( ! empty( $content['image'] ) ) : ?>
                                    <div class="featured-image">
                                        <a href="<?php echo esc_url( $content['url'] ); ?>"><img src="<?php echo esc_url( $content['image'] ); ?>" alt="<?php echo esc_attr( $content['title'] ); ?>"></a>
                                    </div><!-- .featured-image -->
                                <?php endif; ?>

                                <?php if ( ! empty( $content['title'] ) || ! empty( $content['position'] ) ) : ?>
                                        <header class="entry-header">
                                            <?php if ( ! empty( $content['title'] ) ) : ?>
                                                <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                            <?php endif; 

                                            if ( ! empty( $content['position'] ) ) : ?>
                                                <span class="position"><?php echo esc_html( $content['position'] ); ?></span>
                                            <?php endif; ?>
                                        </header>
                                    <?php endif; ?>
                            </div><!-- .client-item-wrapper -->
                        </article>
                    <?php endforeach; ?>
                </div>
            </div>
        </div><!-- #testimonial -->

        </div>

    <?php }
endif;